/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.leveling;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import online.kingdomkeys.kingdomkeys.leveling.StatModifier;

public class Stat {
    String name;
    double value;
    List<StatModifier> modifiers;

    public Stat(String name, double value) {
        this.name = name;
        this.value = value;
        this.modifiers = new ArrayList<StatModifier>();
    }

    public Stat addModifier(String name, double amount, boolean stackable, boolean percentage) {
        this.addModifier(new StatModifier(name, amount, stackable, percentage));
        return this;
    }

    protected void addModifier(StatModifier modifier) {
        if (this.modifiers.stream().noneMatch(m -> m.name.equals(modifier.name))) {
            this.modifiers.add(modifier);
        } else {
            this.modifiers.forEach(m -> {
                if (m.name.equals(modifier.name)) {
                    m.amount = m.stackable ? (m.amount += modifier.amount) : modifier.amount;
                }
            });
        }
    }

    public boolean hasModifier(String name) {
        return this.modifiers.stream().anyMatch(m -> m.name.equals(name));
    }

    public void removeModifier(String name) {
        if (this.modifiers.stream().anyMatch(m -> m.name.equals(name))) {
            this.modifiers.removeIf(modifier -> modifier.name.equals(name));
        }
    }

    public double getStat() {
        double modified = this.value;
        double percentageModifiers = 0.0;
        for (StatModifier modifier : this.modifiers) {
            if (modifier.percentage) {
                percentageModifiers += modifier.amount;
                continue;
            }
            modified += modifier.amount;
        }
        double percentageModified = this.value * (percentageModifiers / 100.0);
        return modified + percentageModified;
    }

    public double get() {
        return this.value;
    }

    public void set(double value) {
        this.value = value;
    }

    public void add(double value) {
        this.value += value;
    }

    public CompoundTag serialize(CompoundTag tag) {
        tag.putDouble(this.name, this.value);
        tag.putInt(this.name + "_modifiers", this.modifiers.size());
        CompoundTag modifierTag = new CompoundTag();
        for (int i = 0; i < this.modifiers.size(); ++i) {
            modifierTag.put("modifier_" + i, (Tag)this.modifiers.get(i).serialize());
        }
        tag.put(this.name + "_modifiers_list", (Tag)modifierTag);
        return tag;
    }

    public static Stat deserializeNBT(String name, CompoundTag tag) {
        Stat stat = new Stat(name, tag.getDouble(name));
        CompoundTag modifierTag = tag.getCompound(name + "_modifiers_list");
        for (int i = 0; i < tag.getInt(name + "_modifiers"); ++i) {
            stat.addModifier(StatModifier.deserialize(modifierTag.getCompound("modifier_" + i)));
        }
        return stat;
    }
}

