/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.lib;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.item.KeychainItem;
import online.kingdomkeys.kingdomkeys.item.organization.IOrgWeapon;

public class DamageCalculation {
    public static float getMagicDamage(Player player, ItemStack stack) {
        if (player != null) {
            PlayerData playerData = PlayerData.get(player);
            if (playerData == null) {
                return 0.0f;
            }
            float damage = 0.0f;
            KeybladeItem keyblade = null;
            if (stack.getItem() instanceof KeychainItem) {
                keyblade = ((KeychainItem)stack.getItem()).getKeyblade();
            } else if (stack.getItem() instanceof KeybladeItem) {
                keyblade = (KeybladeItem)stack.getItem();
            }
            if (keyblade != null) {
                damage = keyblade.getMagic(stack) + playerData.getMagic(true);
                if (!playerData.getActiveDriveForm().equals(DriveForm.NONE.toString())) {
                    DriveForm form = (DriveForm)ModDriveForms.registry.get(ResourceLocation.parse((String)playerData.getActiveDriveForm()));
                    damage *= form.getMagMult();
                }
            }
            return damage;
        }
        return 0.0f;
    }

    public static float getOrgMagicDamage(Player player, IOrgWeapon weapon) {
        if (player != null) {
            PlayerData playerData = PlayerData.get(player);
            if (playerData == null) {
                return 0.0f;
            }
            return weapon.getMagic() + playerData.getMagic(true);
        }
        return 0.0f;
    }

    public static float getMagicDamage(Player player) {
        if (player != null) {
            PlayerData playerData = PlayerData.get(player);
            if (playerData == null) {
                return 0.0f;
            }
            float finalDamage = 0.0f;
            if (player.getItemInHand(InteractionHand.MAIN_HAND) != null && player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof KeybladeItem || player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof IOrgWeapon) {
                if (player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof KeybladeItem) {
                    finalDamage = DamageCalculation.getMagicDamage(player, player.getMainHandItem());
                } else if (player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof IOrgWeapon) {
                    finalDamage = DamageCalculation.getOrgMagicDamage(player, (IOrgWeapon)player.getMainHandItem().getItem());
                }
            } else {
                finalDamage = playerData.getMagic(true);
            }
            return finalDamage;
        }
        return 0.0f;
    }

    public static float getStrengthDamage(Player player) {
        if (player != null) {
            PlayerData playerData = PlayerData.get(player);
            if (playerData == null) {
                return 0.0f;
            }
            float finalDamage = 0.0f;
            if (!player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty() && player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof KeybladeItem || player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof IOrgWeapon) {
                if (player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof KeybladeItem) {
                    finalDamage = DamageCalculation.getKBStrengthDamage(player, player.getMainHandItem());
                } else if (player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof IOrgWeapon) {
                    finalDamage = DamageCalculation.getOrgStrengthDamage(player, player.getMainHandItem());
                }
            } else {
                finalDamage = playerData.getStrength(true);
            }
            return finalDamage;
        }
        return 0.0f;
    }

    public static float getKBStrengthDamage(Player player, ItemStack stack) {
        if (player != null) {
            PlayerData playerData = PlayerData.get(player);
            if (playerData == null) {
                return 0.0f;
            }
            float damage = 0.0f;
            float finalDamage = 0.0f;
            KeybladeItem keyblade = null;
            if (stack.getItem() instanceof KeychainItem) {
                keyblade = ((KeychainItem)stack.getItem()).getKeyblade();
            } else if (stack.getItem() instanceof KeybladeItem) {
                keyblade = (KeybladeItem)stack.getItem();
            }
            if (keyblade != null) {
                damage = keyblade.getStrength(stack) + playerData.getStrength(true);
                if (!playerData.getActiveDriveForm().equals(DriveForm.NONE.toString())) {
                    DriveForm form = (DriveForm)ModDriveForms.registry.get(ResourceLocation.parse((String)playerData.getActiveDriveForm()));
                    damage *= form.getStrMult();
                }
            }
            finalDamage = damage;
            DecimalFormatSymbols otherSymbols = new DecimalFormatSymbols(Locale.getDefault());
            otherSymbols.setDecimalSeparator('.');
            DecimalFormat df = new DecimalFormat("###.##", otherSymbols);
            return Float.parseFloat(df.format(finalDamage));
        }
        return 0.0f;
    }

    public static float getOrgStrengthDamage(Player player, ItemStack stack) {
        if (player != null) {
            PlayerData playerData = PlayerData.get(player);
            float damage = 0.0f;
            float finalDamage = 0.0f;
            Item item = stack.getItem();
            if (item instanceof IOrgWeapon) {
                IOrgWeapon org = (IOrgWeapon)item;
                finalDamage = damage = (float)org.getStrength() + (float)playerData.getStrength(true);
            }
            return finalDamage;
        }
        return 0.0f;
    }

    public static float getSharpnessDamage(ItemStack stack, RegistryAccess registryAccess) {
        int sharpnessLevel = stack.getEnchantmentLevel(registryAccess.holderOrThrow(Enchantments.SHARPNESS));
        return DamageCalculation.getSharpnessDamageFromLevel(sharpnessLevel);
    }

    private static float getSharpnessDamageFromLevel(float lvl) {
        return lvl / 2.0f + 0.5f;
    }
}

