/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.lib;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class PortalData {
    UUID uuid;
    UUID ownerID;
    String name;
    BlockPos pos;
    ResourceKey<Level> dimKey;

    public PortalData(UUID id, String name, double x, double y, double z, ResourceKey<Level> dimID, UUID ownerID) {
        this.uuid = id;
        this.name = name;
        this.pos = new BlockPos((int)x, (int)y, (int)z);
        this.dimKey = dimID;
        this.ownerID = ownerID;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void setUUID(UUID id) {
        this.uuid = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    public ResourceKey<Level> getDimID() {
        return this.dimKey;
    }

    public void setDimID(ResourceKey<Level> dimID) {
        this.dimKey = dimID;
    }

    public UUID getOwnerID() {
        return this.ownerID;
    }

    public void setOwnerID(UUID id) {
        this.ownerID = id;
    }

    public String getShortCoords() {
        return this.name;
    }

    public CompoundTag write() {
        CompoundTag portalNBT = new CompoundTag();
        portalNBT.putUUID("uuid", this.uuid);
        portalNBT.putString("name", this.getName());
        portalNBT.putDouble("x", (double)this.pos.getX());
        portalNBT.putDouble("y", (double)this.pos.getY());
        portalNBT.putDouble("z", (double)this.pos.getZ());
        portalNBT.putString("dim", this.dimKey.location().toString());
        portalNBT.putUUID("owner", this.ownerID);
        return portalNBT;
    }

    public void read(CompoundTag nbt) {
        this.setUUID(nbt.getUUID("uuid"));
        this.setName(nbt.getString("name"));
        this.setPos(new BlockPos((int)nbt.getDouble("x"), (int)nbt.getDouble("y"), (int)nbt.getDouble("z")));
        ResourceLocation rl = ResourceLocation.parse((String)nbt.getString("dim"));
        this.setDimID((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)rl));
        this.setOwnerID(nbt.getUUID("owner"));
    }
}

