/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.item.ModComponents;
import org.jetbrains.annotations.NotNull;

public class FortuneBonusModifier
extends LootModifier {
    public static final Supplier<MapCodec<FortuneBonusModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> FortuneBonusModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, FortuneBonusModifier::new)));

    protected FortuneBonusModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    @Nonnull
    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        String hasLuckyLuckyBonus = "HasLuckyLuckyBonus";
        ItemStack tool = (ItemStack)context.getParamOrNull(LootContextParams.TOOL);
        if (tool != null && !tool.has(ModComponents.HAS_FORTUNE_BONUS)) {
            Entity entity = (Entity)context.getParamOrNull(LootContextParams.THIS_ENTITY);
            BlockState blockState = (BlockState)context.getParamOrNull(LootContextParams.BLOCK_STATE);
            BlockEntity blockEntity = (BlockEntity)context.getParamOrNull(LootContextParams.BLOCK_ENTITY);
            Vec3 origin = (Vec3)context.getParamOrNull(LootContextParams.ORIGIN);
            if (blockState != null && entity instanceof Player) {
                PlayerData playerData;
                int totalFortuneBonus;
                Player player = (Player)entity;
                if (!(blockState.getBlock() instanceof ShulkerBoxBlock) && (totalFortuneBonus = (playerData = PlayerData.get(player)).getNumberOfAbilitiesEquipped("kingdomkeys:ability_lucky_lucky")) > 0) {
                    ItemStack fakeTool = tool.isEmpty() ? new ItemStack((ItemLike)Items.BARRIER) : tool.copy();
                    fakeTool.set(ModComponents.HAS_FORTUNE_BONUS, (Object)true);
                    Holder fortune = player.level().registryAccess().holderOrThrow(Enchantments.FORTUNE);
                    fakeTool.enchant(fortune, fakeTool.getEnchantmentLevel(fortune) + totalFortuneBonus);
                    if (origin == null) {
                        origin = player.position();
                    }
                    LootParams.Builder builder = new LootParams.Builder((ServerLevel)player.level());
                    builder.withParameter(LootContextParams.TOOL, (Object)fakeTool);
                    builder.withParameter(LootContextParams.BLOCK_STATE, (Object)blockState);
                    builder.withParameter(LootContextParams.ORIGIN, (Object)origin);
                    builder.withParameter(LootContextParams.BLOCK_ENTITY, (Object)blockEntity);
                    LootParams newContext = builder.create(LootContextParamSets.BLOCK);
                    LootTable lootTable = context.getLevel().getServer().reloadableRegistries().getLootTable(blockState.getBlock().getLootTable());
                    return lootTable.getRandomItems(newContext);
                }
            }
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return (MapCodec)CODEC;
    }
}

