/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.magic;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.entity.magic.BlizzardEntity;
import online.kingdomkeys.kingdomkeys.entity.magic.BlizzazaEntity;
import online.kingdomkeys.kingdomkeys.magic.Magic;

public class MagicBlizzard
extends Magic {
    public MagicBlizzard(ResourceLocation registryName, int maxLevel, String gmAbility) {
        super(registryName, false, maxLevel, gmAbility);
    }

    @Override
    public void magicUse(Player player, Player caster, int level, float fullMPBlastMult, LivingEntity lockOnEntity) {
        float dmgMult = this.getDamageMult(level) + (float)PlayerData.get(player).getNumberOfAbilitiesEquipped("kingdomkeys:ability_blizzard_boost") * 0.2f;
        dmgMult *= fullMPBlastMult;
        switch (level) {
            case 0: {
                BlizzardEntity blizzard = new BlizzardEntity(player.level(), (LivingEntity)player, dmgMult, 100);
                player.level().addFreshEntity((Entity)blizzard);
                blizzard.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 2.0f, 0.0f);
                break;
            }
            case 1: {
                for (int i = -1; i < 2; ++i) {
                    BlizzardEntity blizzara = new BlizzardEntity(player.level(), (LivingEntity)player, dmgMult * 0.9f, 120);
                    player.level().addFreshEntity((Entity)blizzara);
                    blizzara.shootFromRotation((Entity)player, player.getXRot(), player.getYRot() + (float)(i * 6), 0.0f, 2.0f, 0.0f);
                }
                break;
            }
            case 2: {
                BlizzardEntity blizzara;
                int i;
                for (i = -1; i < 2; ++i) {
                    blizzara = new BlizzardEntity(player.level(), (LivingEntity)player, dmgMult * 0.85f, 130);
                    player.level().addFreshEntity((Entity)blizzara);
                    blizzara.shootFromRotation((Entity)player, player.getXRot(), player.getYRot() + (float)(i * 6), 0.0f, 2.0f, 0.0f);
                }
                for (i = -1; i < 1; ++i) {
                    blizzara = new BlizzardEntity(player.level(), (LivingEntity)player, dmgMult * 0.85f, 130);
                    player.level().addFreshEntity((Entity)blizzara);
                    blizzara.shootFromRotation((Entity)player, player.getXRot() - 6.0f, player.getYRot() + (float)(i * 6) + 3.0f, 0.0f, 2.0f, 0.0f);
                }
                break;
            }
            case 3: {
                BlizzazaEntity blizzaza = new BlizzazaEntity(player.level(), (LivingEntity)player, dmgMult, 200);
                player.level().addFreshEntity((Entity)blizzaza);
                blizzaza.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 2.0f, 0.0f);
            }
        }
    }

    @Override
    protected void playMagicCastSound(Player player, Player caster, int level) {
        switch (level) {
            case 0: {
                player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.blizzard.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 1: {
                player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.blizzara.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 2: {
                player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.blizzaga.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 3: {
                player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.blizzaga.get(), SoundSource.PLAYERS, 1.0f, 0.75f);
            }
        }
    }
}

