/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.magic;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.data.WorldData;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.magic.Magic;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class MagicCure
extends Magic {
    public MagicCure(ResourceLocation registryName, int maxLevel, String gmAbility) {
        super(registryName, true, maxLevel, gmAbility);
    }

    @Override
    public void magicUse(Player player, Player caster, int level, float fullMPBlastMult, LivingEntity lockOnEntity) {
        ((ServerLevel)player.level()).sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER.getType(), player.getX(), player.getY() + 2.3, player.getZ(), 5, 0.0, 0.0, 0.0, 0.0);
        PlayerData playerData = PlayerData.get(player);
        WorldData worldData = WorldData.get(player.getServer());
        float amount = (float)playerData.getMaxHP() * this.getDamageMult(level);
        if (playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_leaf_bracer") > 0) {
            player.invulnerableTime = 40;
        }
        Utils.reviveFromKO((LivingEntity)player);
        switch (level) {
            case 0: {
                player.heal(amount);
                break;
            }
            case 1: {
                player.heal(amount);
                if (worldData.getPartyFromMember(player.getUUID()) == null) break;
                Party party = worldData.getPartyFromMember(player.getUUID());
                List<LivingEntity> list = Utils.getLivingEntitiesInRadius((Entity)player, 3.0f);
                if (list.isEmpty()) break;
                for (int i = 0; i < list.size(); ++i) {
                    LivingEntity e = list.get(i);
                    if (!Utils.isEntityInParty(party, (Entity)e) || e == player) continue;
                    e.heal(amount / 2.0f);
                    Utils.reviveFromKO(e);
                    player.level().playSound(null, e.position().x(), e.position().y(), e.position().z(), (SoundEvent)ModSounds.cura.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                break;
            }
            case 2: {
                player.heal(amount);
                if (worldData.getPartyFromMember(player.getUUID()) == null) break;
                Party party = worldData.getPartyFromMember(player.getUUID());
                List<LivingEntity> list = Utils.getLivingEntitiesInRadius((Entity)player, 5.0f);
                if (list.isEmpty()) break;
                for (int i = 0; i < list.size(); ++i) {
                    LivingEntity e = list.get(i);
                    if (!Utils.isEntityInParty(party, (Entity)e) || e == player) continue;
                    e.heal(amount / 2.0f);
                    Utils.reviveFromKO(e);
                    player.level().playSound(null, e.position().x(), e.position().y(), e.position().z(), (SoundEvent)ModSounds.curaga.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                break;
            }
            case 3: {
                Party party;
                List<Party.Member> list;
                player.heal(amount);
                player.getFoodData().eat(20, 10.0f);
                if (worldData.getPartyFromMember(player.getUUID()) == null || (list = (party = worldData.getPartyFromMember(player.getUUID())).getMembers()).isEmpty()) break;
                for (int i = 0; i < list.size(); ++i) {
                    Player e;
                    if (player.level().getPlayerByUUID(list.get(i).getUUID()) == null || !(player.distanceTo((Entity)player.level().getPlayerByUUID(list.get(i).getUUID())) < (float)((Integer)ModConfigs.SERVER.partyRangeLimit.get()).intValue()) || (e = player.level().getPlayerByUUID(list.get(i).getUUID())) == null || !Utils.isEntityInParty(party, (Entity)e) || e == player) continue;
                    e.heal(amount);
                    if (!(e instanceof Player)) continue;
                    Player targetPlayer = e;
                    targetPlayer.getFoodData().eat(20, 10.0f);
                }
                break;
            }
        }
        caster.swing(InteractionHand.MAIN_HAND);
    }

    @Override
    protected void playMagicCastSound(Player player, Player caster, int level) {
        switch (level) {
            case 0: {
                player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.cure.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 1: {
                player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.cura.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 2: {
                player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.curaga.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 3: {
                player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.curaga.get(), SoundSource.PLAYERS, 1.0f, 0.8f);
            }
        }
    }
}

