/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.magic;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.magic.Magic;
import online.kingdomkeys.kingdomkeys.magic.MagicData;
import online.kingdomkeys.kingdomkeys.magic.MagicDataDeserializer;
import online.kingdomkeys.kingdomkeys.magic.ModMagic;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncMagicData;

public class MagicDataLoader
extends SimpleJsonResourceReloadListener {
    public static final Gson GSON_BUILDER = new GsonBuilder().registerTypeAdapter(MagicData.class, (Object)new MagicDataDeserializer()).setPrettyPrinting().create();
    public static List<String> names = new LinkedList<String>();
    public static List<String> dataList = new LinkedList<String>();

    public MagicDataLoader() {
        super(GSON_BUILDER, "magics");
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        AtomicInteger count = new AtomicInteger();
        objectIn.forEach((resourceLocation, element) -> {
            try {
                if (ModMagic.registry.containsKey(resourceLocation)) {
                    Magic magic = (Magic)ModMagic.registry.get(resourceLocation);
                    dataList.add(element.toString());
                    MagicData result = (MagicData)GSON_BUILDER.fromJson(element, MagicData.class);
                    names.add(resourceLocation.toString());
                    magic.setMagicData(result);
                    count.incrementAndGet();
                } else {
                    KingdomKeys.LOGGER.warn("Found magic data {} for magic that doesn't exist", resourceLocation);
                }
            }
            catch (JsonParseException e) {
                KingdomKeys.LOGGER.error("Error parsing magic json file {}: {}", resourceLocation, (Object)e);
            }
        });
        KingdomKeys.LOGGER.info("Loaded {} magics data", (Object)count.get());
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayers()) {
                PacketHandler.sendTo(new SCSyncMagicData(names, dataList), player);
            }
        }
    }
}

