/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.magic;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.entity.magic.FiraEntity;
import online.kingdomkeys.kingdomkeys.entity.magic.FiragaEntity;
import online.kingdomkeys.kingdomkeys.entity.magic.FirazaEntity;
import online.kingdomkeys.kingdomkeys.entity.magic.FireEntity;
import online.kingdomkeys.kingdomkeys.magic.Magic;

public class MagicFire
extends Magic {
    public MagicFire(ResourceLocation registryName, int maxLevel, String gmAbility) {
        super(registryName, false, maxLevel, gmAbility);
    }

    @Override
    public void magicUse(Player player, Player caster, int level, float fullMPBlastMult, LivingEntity lockOnEntity) {
        float dmgMult = this.getDamageMult(level) + (float)PlayerData.get(player).getNumberOfAbilitiesEquipped("kingdomkeys:ability_fire_boost") * 0.2f;
        dmgMult *= fullMPBlastMult;
        lockOnEntity = this.getMagicLockOn(level) ? lockOnEntity : null;
        switch (level) {
            case 0: {
                FireEntity fire = new FireEntity(player.level(), (LivingEntity)player, dmgMult, lockOnEntity);
                player.level().addFreshEntity((Entity)fire);
                fire.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 2.0f, 0.0f);
                break;
            }
            case 1: {
                FiraEntity fira = new FiraEntity(player.level(), (LivingEntity)player, dmgMult, lockOnEntity);
                player.level().addFreshEntity((Entity)fira);
                fira.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 2.0f, 0.0f);
                break;
            }
            case 2: {
                FiragaEntity firaga = new FiragaEntity(player.level(), (LivingEntity)player, dmgMult, lockOnEntity);
                player.level().addFreshEntity((Entity)firaga);
                firaga.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 2.0f, 0.0f);
                break;
            }
            case 3: {
                FirazaEntity firaza = new FirazaEntity(player.level(), (LivingEntity)player, dmgMult);
                player.level().addFreshEntity((Entity)firaza);
                firaza.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 2.0f, 0.0f);
            }
        }
    }

    @Override
    protected void playMagicCastSound(Player player, Player caster, int level) {
        switch (level) {
            case 0: {
                player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.fire.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 1: {
                player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.fira.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 2: {
                player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.firaga.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 3: {
                player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.firaga.get(), SoundSource.PLAYERS, 1.0f, 0.7f);
            }
        }
    }
}

