/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.magic;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.entity.magic.GravigaEntity;
import online.kingdomkeys.kingdomkeys.entity.magic.GraviraEntity;
import online.kingdomkeys.kingdomkeys.entity.magic.GravityEntity;
import online.kingdomkeys.kingdomkeys.magic.Magic;

public class MagicGravity
extends Magic {
    public MagicGravity(ResourceLocation registryName, int maxLevel, String gmAbility) {
        super(registryName, false, maxLevel, gmAbility);
    }

    @Override
    public void magicUse(Player player, Player caster, int level, float fullMPBlastMult, LivingEntity lockOnEntity) {
        float dmg = this.getDamageMult(level);
        dmg *= fullMPBlastMult;
        switch (level) {
            case 0: {
                GravityEntity gravity = new GravityEntity(player.level(), player, dmg);
                player.level().addFreshEntity((Entity)gravity);
                gravity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 2.0f, 0.0f);
                if (lockOnEntity == null) break;
                gravity.setPos(lockOnEntity.getX(), lockOnEntity.getY(), lockOnEntity.getZ());
                break;
            }
            case 1: {
                GraviraEntity gravira = new GraviraEntity(player.level(), player, dmg * 1.1f);
                player.level().addFreshEntity((Entity)gravira);
                gravira.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 2.3f, 0.0f);
                if (lockOnEntity == null) break;
                gravira.setPos(lockOnEntity.getX(), lockOnEntity.getY(), lockOnEntity.getZ());
                break;
            }
            case 2: {
                GravigaEntity graviga = new GravigaEntity(player.level(), player, dmg * 1.2f);
                player.level().addFreshEntity((Entity)graviga);
                graviga.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 2.6f, 0.0f);
                if (lockOnEntity == null) break;
                graviga.setPos(lockOnEntity.getX(), lockOnEntity.getY(), lockOnEntity.getZ());
            }
        }
        player.swing(InteractionHand.MAIN_HAND);
    }

    @Override
    protected void playMagicCastSound(Player player, Player caster, int level) {
        switch (level) {
            case 0: {
                player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.gravity.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 1: {
                player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.gravira.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 2: {
                player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.graviga.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 3: {
                player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.graviga.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }
}

