/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.magic;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.data.GlobalData;
import online.kingdomkeys.kingdomkeys.data.WorldData;
import online.kingdomkeys.kingdomkeys.effects.ModMobEffects;
import online.kingdomkeys.kingdomkeys.entity.mob.MarluxiaEntity;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.magic.Magic;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncGlobalData;

public class MagicStop
extends Magic {
    public MagicStop(ResourceLocation registryName, int maxLevel, String gmAbility) {
        super(registryName, false, maxLevel, gmAbility);
    }

    @Override
    public void magicUse(Player player, Player caster, int level, float fullMPBlastMult, LivingEntity lockOnEntity) {
        float dmg = this.getDamageMult(level);
        dmg *= fullMPBlastMult;
        float radius = 2 + level;
        List list = player.level().getEntities((Entity)player, player.getBoundingBox().inflate((double)radius, (double)radius, (double)radius));
        Party casterParty = WorldData.get(player.getServer()).getPartyFromMember(player.getUUID());
        if (casterParty != null && !casterParty.getFriendlyFire()) {
            for (Party.Member m : casterParty.getMembers()) {
                list.remove(player.level().getPlayerByUUID(m.getUUID()));
            }
        }
        list.removeIf(e -> e instanceof MarluxiaEntity);
        GlobalData casterGlobalData = GlobalData.get((LivingEntity)caster);
        if (casterGlobalData != null) {
            casterGlobalData.setStopModelTicks(10);
            PacketHandler.syncToAllAround((LivingEntity)caster, casterGlobalData);
        }
        if (!list.isEmpty()) {
            for (Entity e2 : list) {
                if (!(e2 instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)e2;
                GlobalData globalData = GlobalData.get(livingEntity);
                if (livingEntity instanceof Mob) {
                    ((Mob)e2).setNoAi(true);
                }
                livingEntity.addEffect(new MobEffectInstance(ModMobEffects.STOP, (int)(100.0f + (float)(level * 20) * dmg), level, false, false, false));
                globalData.setStopCaster(caster.getDisplayName().getString());
                if (!(e2 instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)e2;
                PacketHandler.sendTo(new SCSyncGlobalData(livingEntity), serverPlayer);
            }
        }
        player.swing(InteractionHand.MAIN_HAND);
    }

    @Override
    protected void playMagicCastSound(Player player, Player caster, int level) {
        switch (level) {
            case 0: {
                player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.stop.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 1: {
                player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.stopra.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 2: {
                player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.stopga.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }
}

