/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.menu;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import online.kingdomkeys.kingdomkeys.block.ModBlocks;
import online.kingdomkeys.kingdomkeys.entity.block.GummiEditorTileEntity;
import online.kingdomkeys.kingdomkeys.menu.ModMenus;

public class GummiEditorMenu
extends AbstractContainerMenu {
    public final GummiEditorTileEntity TE;
    private final ContainerLevelAccess canInteractWith;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int GUMMI_EDITOR_SLOTS = 1;
    public static final int TILE_INVENTORY_YPOS = 20;
    public static final int PLAYER_INVENTORY_YPOS = 51;

    public GummiEditorMenu(int windowID, Inventory playerInventory, GummiEditorTileEntity tileEntity) {
        super(ModMenus.GUMMI_EDITOR.get(), windowID);
        int i;
        this.TE = tileEntity;
        this.canInteractWith = ContainerLevelAccess.create((Level)this.TE.getLevel(), (BlockPos)this.TE.getBlockPos());
        IItemHandler iih = (IItemHandler)this.TE.inventory.get();
        this.addSlot((Slot)new SlotItemHandler(this, iih, 0, 152, 9){

            public boolean mayPlace(ItemStack stack) {
                return true;
            }
        });
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 105 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 163));
        }
    }

    private static GummiEditorTileEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf buf) {
        BlockEntity te = playerInventory.player.level().getBlockEntity(buf.readBlockPos());
        if (te instanceof GummiEditorTileEntity) {
            return (GummiEditorTileEntity)te;
        }
        throw new IllegalStateException("Tile Entity mismatch with container");
    }

    public GummiEditorMenu(int windowId, Inventory playerInventory, FriendlyByteBuf buf) {
        this(windowId, playerInventory, GummiEditorMenu.getTileEntity(playerInventory, buf));
    }

    public boolean stillValid(Player playerIn) {
        return GummiEditorMenu.stillValid((ContainerLevelAccess)this.canInteractWith, (Player)playerIn, (Block)ModBlocks.gummiEditor.get());
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < 1 ? !this.moveItemStackTo(itemstack1, 1, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, 1, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }
}

