/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.menu;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import online.kingdomkeys.kingdomkeys.block.ModBlocks;
import online.kingdomkeys.kingdomkeys.entity.block.MagicalChestTileEntity;
import online.kingdomkeys.kingdomkeys.menu.ModMenus;

public class MagicalChestMenu
extends AbstractContainerMenu {
    public final MagicalChestTileEntity TE;
    private final ContainerLevelAccess canInteractWith;
    private static final int CHEST_SLOTS = 36;

    public MagicalChestMenu(int windowID, Inventory playerInventory, MagicalChestTileEntity tileEntity) {
        super(ModMenus.MAGICAL_CHEST.get(), windowID);
        int j;
        int i;
        this.TE = tileEntity;
        this.canInteractWith = ContainerLevelAccess.create((Level)this.TE.getLevel(), (BlockPos)this.TE.getBlockPos());
        IItemHandler iih = (IItemHandler)this.TE.inventory.get();
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSlot((Slot)new SlotItemHandler(iih, j + i * 9, 8 + j * 18, 20 + i * 18));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 105 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 163));
        }
    }

    private static MagicalChestTileEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf buf) {
        BlockEntity te = playerInventory.player.level().getBlockEntity(buf.readBlockPos());
        if (te instanceof MagicalChestTileEntity) {
            return (MagicalChestTileEntity)te;
        }
        throw new IllegalStateException("Tile Entity mismatch with container");
    }

    public MagicalChestMenu(int windowId, Inventory playerInventory, FriendlyByteBuf buf) {
        this(windowId, playerInventory, MagicalChestMenu.getTileEntity(playerInventory, buf));
    }

    public boolean stillValid(Player playerIn) {
        return MagicalChestMenu.stillValid((ContainerLevelAccess)this.canInteractWith, (Player)playerIn, (Block)ModBlocks.magicalChest.get());
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < 36 ? !this.moveItemStackTo(itemstack1, 36, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }
}

