/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.menu;

import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.IContainerFactory;
import net.neoforged.neoforge.registries.DeferredRegister;
import online.kingdomkeys.kingdomkeys.client.gui.container.GummiEditorScreen;
import online.kingdomkeys.kingdomkeys.client.gui.container.MagicalChestScreen;
import online.kingdomkeys.kingdomkeys.client.gui.container.PauldronScreen;
import online.kingdomkeys.kingdomkeys.client.gui.container.PedestalScreen;
import online.kingdomkeys.kingdomkeys.client.gui.container.SynthesisBagScreen;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.item.ModItems;
import online.kingdomkeys.kingdomkeys.menu.GummiEditorMenu;
import online.kingdomkeys.kingdomkeys.menu.MagicalChestMenu;
import online.kingdomkeys.kingdomkeys.menu.PauldronInventory;
import online.kingdomkeys.kingdomkeys.menu.PauldronMenu;
import online.kingdomkeys.kingdomkeys.menu.PedestalMenu;
import online.kingdomkeys.kingdomkeys.menu.SynthesisBagInventory;
import online.kingdomkeys.kingdomkeys.menu.SynthesisBagMenu;

public class ModMenus {
    public static final DeferredRegister<MenuType<?>> MENUS = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)"kingdomkeys");
    public static final Supplier<MenuType<SynthesisBagMenu>> SYNTHESIS_BAG = ModMenus.createMenu("synthesis_bag", SynthesisBagMenu::fromNetwork);
    public static final Supplier<MenuType<PedestalMenu>> PEDESTAL = ModMenus.createMenu("pedestal_container", PedestalMenu::new);
    public static final Supplier<MenuType<MagicalChestMenu>> MAGICAL_CHEST = ModMenus.createMenu("magical_chest", MagicalChestMenu::new);
    public static final Supplier<MenuType<GummiEditorMenu>> GUMMI_EDITOR = ModMenus.createMenu("gummi_editor_container", GummiEditorMenu::new);
    public static final Supplier<MenuType<PauldronMenu>> PAULDRON = ModMenus.createMenu("pauldron", PauldronMenu::fromNetwork);

    public static <M extends AbstractContainerMenu> Supplier<MenuType<M>> createMenu(String name, IContainerFactory<M> container) {
        return MENUS.register(name, () -> new MenuType((MenuType.MenuSupplier)container, FeatureFlags.DEFAULT_FLAGS));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerGUIFactories(RegisterMenuScreensEvent event) {
        event.register(SYNTHESIS_BAG.get(), SynthesisBagScreen::new);
        event.register(PEDESTAL.get(), PedestalScreen::new);
        event.register(MAGICAL_CHEST.get(), MagicalChestScreen::new);
        event.register(GUMMI_EDITOR.get(), GummiEditorScreen::new);
        event.register(PAULDRON.get(), PauldronScreen::new);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.ItemHandler.ITEM, (object, context) -> new SynthesisBagInventory((MutableDataComponentHolder)object), new ItemLike[]{(ItemLike)ModItems.synthesisBag.get()});
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, ModEntities.TYPE_PEDESTAL.get(), (object, context) -> (IItemHandler)object.inventory.get());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, ModEntities.TYPE_MAGICAL_CHEST.get(), (object, context) -> (IItemHandler)object.inventory.get());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, ModEntities.TYPE_GUMMI_EDITOR.get(), (object, context) -> (IItemHandler)object.inventory.get());
        event.registerItem(Capabilities.ItemHandler.ITEM, (object, context) -> new PauldronInventory((MutableDataComponentHolder)object), new ItemLike[]{(ItemLike)ModItems.terra_Shoulder.get(), (ItemLike)ModItems.aqua_Shoulder.get(), (ItemLike)ModItems.ventus_Shoulder.get(), (ItemLike)ModItems.eraqus_Shoulder.get(), (ItemLike)ModItems.xehanort_Shoulder.get(), (ItemLike)ModItems.nightmareVentus_Shoulder.get(), (ItemLike)ModItems.ux_Shoulder.get()});
    }
}

