/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.menu;

import com.mojang.datafixers.util.Pair;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class PauldronSlot
extends SlotItemHandler {
    private int index;
    static final ResourceLocation[] TEXTURE_EMPTY_SLOTS = new ResourceLocation[]{InventoryMenu.EMPTY_ARMOR_SLOT_HELMET, InventoryMenu.EMPTY_ARMOR_SLOT_CHESTPLATE, InventoryMenu.EMPTY_ARMOR_SLOT_LEGGINGS, InventoryMenu.EMPTY_ARMOR_SLOT_BOOTS};

    public PauldronSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
        super(itemHandler, index, xPosition, yPosition);
        this.index = index;
    }

    public boolean mayPlace(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            return switch (this.index) {
                case 0 -> armorItem.getType().equals((Object)ArmorItem.Type.HELMET);
                case 1 -> armorItem.getType().equals((Object)ArmorItem.Type.CHESTPLATE);
                case 2 -> armorItem.getType().equals((Object)ArmorItem.Type.LEGGINGS);
                case 3 -> armorItem.getType().equals((Object)ArmorItem.Type.BOOTS);
                default -> false;
            };
        }
        return stack.getItem() instanceof ArmorItem | stack.isEmpty();
    }

    public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
        return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)TEXTURE_EMPTY_SLOTS[this.index]);
    }
}

