/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.menu;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import online.kingdomkeys.kingdomkeys.item.ModComponents;
import online.kingdomkeys.kingdomkeys.menu.ModMenus;
import online.kingdomkeys.kingdomkeys.menu.SynthesisBagInventory;
import online.kingdomkeys.kingdomkeys.menu.SynthesisBagSlot;

public class SynthesisBagMenu
extends AbstractContainerMenu {
    public final ItemStack bag;

    public static SynthesisBagMenu fromNetwork(int windowId, Inventory inv, FriendlyByteBuf buf) {
        InteractionHand hand = buf.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        return new SynthesisBagMenu(windowId, inv, inv.player.getItemInHand(hand));
    }

    public SynthesisBagMenu(int windowId, Inventory playerInv, ItemStack bag) {
        super(ModMenus.SYNTHESIS_BAG.get(), windowId);
        this.bag = bag;
        SynthesisBagInventory bagInv = (SynthesisBagInventory)((Object)bag.getCapability(Capabilities.ItemHandler.ITEM));
        if (bagInv != null) {
            int j;
            int i;
            int bagLevel = (Integer)bag.get(ModComponents.SYNTH_BAG_LEVEL);
            int invStart = bagLevel * 2;
            for (i = 0; i < 2 * (bagLevel + 1); ++i) {
                for (j = 0; j < 9; ++j) {
                    int k = j + i * 9;
                    this.addSlot((Slot)new SynthesisBagSlot((IItemHandlerModifiable)bagInv, k, 8 + j * 18, 18 + i * 18));
                }
            }
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 9; ++j) {
                    this.addSlot(new Slot((Container)playerInv, j + i * 9 + 9, 8 + j * 18, 58 + (i + invStart) * 18));
                }
            }
            for (i = 0; i < 9; ++i) {
                this.addSlot(new Slot((Container)playerInv, i, 8 + i * 18, 62 + (3 + invStart) * 18));
            }
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        int bagLevel = (Integer)this.bag.get(ModComponents.SYNTH_BAG_LEVEL);
        int maxSlots = switch (bagLevel) {
            case 0 -> 18;
            case 1 -> 36;
            case 2 -> 54;
            case 3 -> 72;
            default -> 0;
        };
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < maxSlots ? !this.moveItemStackTo(itemstack1, maxSlots, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, maxSlots, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public void clicked(int slot, int dragType, ClickType clickTypeIn, Player player) {
        if (slot < 0 || this.getSlot(slot).getItem() != this.bag) {
            super.clicked(slot, dragType, clickTypeIn, player);
        }
    }
}

