/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.mixin.client;

import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.biome.Biome;
import online.kingdomkeys.kingdomkeys.data.CastleOblivionData;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.floor.Floor;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.Room;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Biome.class})
public class BiomeMixin {
    @Inject(method={"getBackgroundMusic"}, at={@At(value="HEAD")}, cancellable=true)
    public void replaceBiomeMusic(CallbackInfoReturnable<Optional<Music>> cir) {
        CastleOblivionData.InteriorData interiorData;
        Holder currentBiome = Minecraft.getInstance().level.getBiome(Minecraft.getInstance().player.blockPosition());
        if (currentBiome.isBound() && currentBiome.is(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"castle_oblivion_interior")) && (interiorData = CastleOblivionData.InteriorData.getClient(Minecraft.getInstance().level)) != null && !interiorData.getFloors().isEmpty()) {
            Floor floor = interiorData.getFloorAtPos(Minecraft.getInstance().player.blockPosition());
            Room room = interiorData.getRoomAtPos(Minecraft.getInstance().player.blockPosition());
            if (floor != null) {
                SoundEvent music = null;
                if (floor.getType().getMusic() != null) {
                    music = floor.getType().getMusic();
                }
                if (room != null && room.getType().getMusic() != null) {
                    music = room.getType().getMusic();
                }
                if (music != null) {
                    cir.setReturnValue(Optional.of(new Music(Holder.direct((Object)music), 0, 0, true)));
                } else {
                    cir.setReturnValue(Optional.of(new Music(Holder.direct((Object)((SoundEvent)SoundEvents.MUSIC_GAME.value())), 12000, 24000, true)));
                }
            }
        }
    }
}

