/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.player.CriticalHitEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import online.kingdomkeys.kingdomkeys.damagesource.KeybladeDamageSource;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.network.Packet;
import online.kingdomkeys.kingdomkeys.util.IExtendedReach;

public record CSAttackOffhandPacket(int entityId) implements Packet
{
    public static final CustomPacketPayload.Type<CSAttackOffhandPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"cs_attack_off_hand"));
    public static final StreamCodec<FriendlyByteBuf, CSAttackOffhandPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, CSAttackOffhandPacket::entityId, CSAttackOffhandPacket::new);

    public static void attackTargetEntityWithOffhandItem(ServerPlayer player, Entity targetEntity) {
        if (!CommonHooks.onPlayerAttackTarget((Player)player, (Entity)targetEntity)) {
            return;
        }
        if (targetEntity.isAttackable() && !targetEntity.skipAttackInteraction((Entity)player)) {
            Projectile projectile;
            float damage = 1.0f;
            DamageSource damagesource = KeybladeDamageSource.causeOffhandKeybladeDamage((Player)player);
            ItemStack itemstack = player.getOffhandItem();
            float enchantDamage = CSAttackOffhandPacket.getEnchantedDamage(player, targetEntity, damage, damagesource) - damage;
            float scale = player.getAttackStrengthScale(0.5f);
            damage *= 0.2f + scale * scale * 0.8f;
            enchantDamage *= scale;
            if (targetEntity.getType().is(EntityTypeTags.REDIRECTABLE_PROJECTILE) && targetEntity instanceof Projectile && (projectile = (Projectile)targetEntity).deflect(ProjectileDeflection.AIM_DEFLECT, (Entity)player, (Entity)player, true)) {
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_NODAMAGE, player.getSoundSource());
                return;
            }
            if (damage > 0.0f || enchantDamage > 0.0f) {
                boolean knockback;
                boolean charged;
                boolean bl = charged = scale > 0.9f;
                if (player.isSprinting() && charged) {
                    player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_KNOCKBACK, player.getSoundSource(), 1.0f, 1.0f);
                    knockback = true;
                } else {
                    knockback = false;
                }
                damage += itemstack.getItem().getAttackDamageBonus(targetEntity, damage, damagesource);
                boolean isCrit = charged && player.fallDistance > 0.0f && !player.onGround() && !player.onClimbable() && !player.isInWater() && !player.hasEffect(MobEffects.BLINDNESS) && !player.isPassenger() && targetEntity instanceof LivingEntity && !player.isSprinting();
                CriticalHitEvent critEvent = CommonHooks.fireCriticalHit((Player)player, (Entity)targetEntity, (boolean)isCrit, (float)(isCrit ? 1.5f : 1.0f));
                isCrit = critEvent.isCriticalHit();
                if (isCrit) {
                    damage *= critEvent.getDamageMultiplier();
                }
                float combinedDamage = damage + enchantDamage;
                boolean canSweep = false;
                double d0 = player.walkDist - player.walkDistO;
                if (charged && !isCrit && !knockback && player.onGround() && d0 < (double)player.getSpeed()) {
                    ItemStack itemstack1 = player.getItemInHand(InteractionHand.OFF_HAND);
                    if (itemstack.getItem() instanceof KeybladeItem) {
                        canSweep = itemstack1.canPerformAction(ItemAbilities.SWORD_SWEEP);
                    }
                }
                float targetHealth = 0.0f;
                if (targetEntity instanceof LivingEntity) {
                    LivingEntity livingentity = (LivingEntity)targetEntity;
                    targetHealth = livingentity.getHealth();
                }
                Vec3 vec3 = targetEntity.getDeltaMovement();
                boolean wasHurt = targetEntity.hurt(damagesource, combinedDamage);
                if (wasHurt) {
                    float f4 = CSAttackOffhandPacket.getKnockback(player, targetEntity, damagesource) + (knockback ? 1.0f : 0.0f);
                    if (f4 > 0.0f) {
                        if (targetEntity instanceof LivingEntity) {
                            LivingEntity livingentity1 = (LivingEntity)targetEntity;
                            livingentity1.knockback((double)(f4 * 0.5f), (double)Mth.sin((float)(player.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(player.getYRot() * ((float)Math.PI / 180)))));
                        } else {
                            targetEntity.push((double)(-Mth.sin((float)(player.getYRot() * ((float)Math.PI / 180))) * f4 * 0.5f), 0.1, (double)(Mth.cos((float)(player.getYRot() * ((float)Math.PI / 180))) * f4 * 0.5f));
                        }
                        player.setDeltaMovement(player.getDeltaMovement().multiply(0.6, 1.0, 0.6));
                        player.setSprinting(false);
                    }
                    if (canSweep) {
                        float sweepDamage = 1.0f + (float)player.getAttributeValue(Attributes.SWEEPING_DAMAGE_RATIO) * damage;
                        for (LivingEntity livingentity2 : player.level().getEntitiesOfClass(LivingEntity.class, targetEntity.getBoundingBox().inflate(1.0, 0.25, 1.0))) {
                            double entityReachSq = Mth.square((double)player.entityInteractionRange());
                            if (livingentity2 == player || livingentity2 == targetEntity || player.isAlliedTo((Entity)livingentity2) || livingentity2 instanceof ArmorStand && ((ArmorStand)livingentity2).isMarker() || !(player.distanceToSqr((Entity)livingentity2) < entityReachSq)) continue;
                            float totalSweepDamage = CSAttackOffhandPacket.getEnchantedDamage(player, (Entity)livingentity2, sweepDamage, damagesource) * scale;
                            livingentity2.knockback((double)0.4f, (double)Mth.sin((float)(player.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(player.getYRot() * ((float)Math.PI / 180)))));
                            livingentity2.hurt(damagesource, totalSweepDamage);
                            Level level = player.level();
                            if (!(level instanceof ServerLevel)) continue;
                            ServerLevel serverlevel = (ServerLevel)level;
                            EnchantmentHelper.doPostAttackEffects((ServerLevel)serverlevel, (Entity)livingentity2, (DamageSource)damagesource);
                        }
                        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, player.getSoundSource(), 1.0f, 1.0f);
                        player.sweepAttack();
                    }
                    if (targetEntity instanceof ServerPlayer && targetEntity.hurtMarked) {
                        ((ServerPlayer)targetEntity).connection.send((net.minecraft.network.protocol.Packet)new ClientboundSetEntityMotionPacket(targetEntity));
                        targetEntity.hurtMarked = false;
                        targetEntity.setDeltaMovement(vec3);
                    }
                    if (isCrit) {
                        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_CRIT, player.getSoundSource(), 1.0f, 1.0f);
                        player.crit(targetEntity);
                    }
                    if (!isCrit && !canSweep) {
                        if (charged) {
                            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_STRONG, player.getSoundSource(), 1.0f, 1.0f);
                        } else {
                            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_WEAK, player.getSoundSource(), 1.0f, 1.0f);
                        }
                    }
                    if (enchantDamage > 0.0f) {
                        player.magicCrit(targetEntity);
                    }
                    player.setLastHurtMob(targetEntity);
                    Entity entity = targetEntity;
                    if (targetEntity instanceof PartEntity) {
                        entity = ((PartEntity)targetEntity).getParent();
                    }
                    boolean itemHurt = false;
                    ItemStack copy = itemstack.copy();
                    Level level = player.level();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverlevel1 = (ServerLevel)level;
                        if (entity instanceof LivingEntity) {
                            LivingEntity livingentity3 = (LivingEntity)entity;
                            itemHurt = itemstack.hurtEnemy(livingentity3, (Player)player);
                        }
                        EnchantmentHelper.doPostAttackEffects((ServerLevel)serverlevel1, (Entity)targetEntity, (DamageSource)damagesource);
                    }
                    if (!player.level().isClientSide && !itemstack.isEmpty() && entity instanceof LivingEntity) {
                        if (itemHurt) {
                            itemstack.postHurtEnemy((LivingEntity)entity, (Player)player);
                        }
                        if (itemstack.isEmpty()) {
                            EventHooks.onPlayerDestroyItem((Player)player, (ItemStack)copy, (InteractionHand)(itemstack == player.getOffhandItem() ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND));
                            if (itemstack == player.getOffhandItem()) {
                                player.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
                            } else {
                                player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                            }
                        }
                    }
                    if (targetEntity instanceof LivingEntity) {
                        float damageDealt = targetHealth - ((LivingEntity)targetEntity).getHealth();
                        player.awardStat(Stats.DAMAGE_DEALT, Math.round(damageDealt * 10.0f));
                        if (player.level() instanceof ServerLevel && damageDealt > 2.0f) {
                            int i = (int)((double)damageDealt * 0.5);
                            ((ServerLevel)player.level()).sendParticles((ParticleOptions)ParticleTypes.DAMAGE_INDICATOR, targetEntity.getX(), targetEntity.getY(0.5), targetEntity.getZ(), i, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                    player.causeFoodExhaustion(0.1f);
                } else {
                    player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_NODAMAGE, player.getSoundSource(), 1.0f, 1.0f);
                }
            }
            player.swing(InteractionHand.OFF_HAND);
        }
    }

    public static float getKnockback(ServerPlayer player, Entity pAttacker, DamageSource pDamageSource) {
        float f;
        float f2 = (float)player.getAttributeValue(Attributes.ATTACK_KNOCKBACK);
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            f = EnchantmentHelper.modifyKnockback((ServerLevel)serverlevel, (ItemStack)player.getOffhandItem(), (Entity)pAttacker, (DamageSource)pDamageSource, (float)f2);
        } else {
            f = f2;
        }
        return f;
    }

    public static float getEnchantedDamage(ServerPlayer player, Entity pEntity, float pDamage, DamageSource pDamageSource) {
        return EnchantmentHelper.modifyDamage((ServerLevel)player.serverLevel(), (ItemStack)player.getWeaponItem(), (Entity)pEntity, (DamageSource)pDamageSource, (float)pDamage);
    }

    @Override
    public void handle(IPayloadContext context) {
        Item item;
        Player player = context.player();
        Entity entity = player.level().getEntity(this.entityId);
        if (entity != null && (item = player.getOffhandItem().getItem()) instanceof IExtendedReach) {
            IExtendedReach theExtendedReachWeapon = (IExtendedReach)item;
            double distanceSq = player.distanceToSqr(entity);
            float reach = Math.max(5.0f, theExtendedReachWeapon.getReach());
            double reachSq = reach * reach;
            if (reachSq >= distanceSq) {
                CSAttackOffhandPacket.attackTargetEntityWithOffhandItem((ServerPlayer)player, entity);
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

