/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import com.mojang.datafixers.util.Pair;
import java.time.Instant;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import online.kingdomkeys.kingdomkeys.block.SavePointBlock;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.entity.block.SavepointTileEntity;
import online.kingdomkeys.kingdomkeys.network.Packet;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCUpdateSavePoints;
import online.kingdomkeys.kingdomkeys.world.SavePointStorage;

public record CSCreateSavePoint(BlockPos tileEntity, String name, UUID owner, String ownerName, boolean global) implements Packet
{
    public static final CustomPacketPayload.Type<CSCreateSavePoint> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"cs_create_save_point"));
    public static final StreamCodec<FriendlyByteBuf, CSCreateSavePoint> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, CSCreateSavePoint::tileEntity, (StreamCodec)ByteBufCodecs.STRING_UTF8, CSCreateSavePoint::name, (StreamCodec)UUIDUtil.STREAM_CODEC, CSCreateSavePoint::owner, (StreamCodec)ByteBufCodecs.STRING_UTF8, CSCreateSavePoint::ownerName, (StreamCodec)ByteBufCodecs.BOOL, CSCreateSavePoint::global, CSCreateSavePoint::new);

    public CSCreateSavePoint(SavepointTileEntity tileEntity, String name, Player player, boolean global) {
        this(tileEntity.getBlockPos(), name, player.getGameProfile().getId(), player.getGameProfile().getName(), global);
    }

    @Override
    public void handle(IPayloadContext context) {
        ServerPlayer player = (ServerPlayer)context.player();
        Level level = player.level();
        SavePointStorage storage = SavePointStorage.getStorage(player.server);
        SavepointTileEntity te = (SavepointTileEntity)level.getBlockEntity(this.tileEntity);
        storage.addSavePoint(new SavePointStorage.SavePoint(te.getID(), (SavePointStorage.SavePointType)((Object)te.getBlockState().getValue(SavePointBlock.TIER)), this.name, te.getBlockPos(), (Pair<UUID, String>)Pair.of((Object)this.owner, (Object)this.ownerName), (ResourceKey<Level>)level.dimension(), this.global, Instant.now()));
        if (!this.global) {
            PlayerData.get((Player)player).addDiscoveredSavePoint(te.getID(), Instant.now());
        }
        MinecraftServer server = level.getServer();
        Iterable levels = server.getAllLevels();
        for (Level level1 : levels) {
            for (Player playerFromList : level1.players()) {
                PacketHandler.sendTo(new SCUpdateSavePoints(SavePointStorage.getStorage(server).getDiscoveredSavePoints(playerFromList)), (ServerPlayer)playerFromList);
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

