/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import online.kingdomkeys.kingdomkeys.integration.epicfight.EpicFightUtils;
import online.kingdomkeys.kingdomkeys.network.Packet;
import online.kingdomkeys.kingdomkeys.util.IExtendedReach;

public record CSExtendedReach(int entityId) implements Packet
{
    public static final CustomPacketPayload.Type<CSExtendedReach> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"cs_extended_reach"));
    public static final StreamCodec<FriendlyByteBuf, CSExtendedReach> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, CSExtendedReach::entityId, CSExtendedReach::new);

    @Override
    public void handle(IPayloadContext context) {
        Player player = context.player();
        Entity theEntity = player.level().getEntity(this.entityId);
        if (EpicFightUtils.isBattleMode(player)) {
            return;
        }
        if (ItemStack.matches((ItemStack)player.getMainHandItem(), (ItemStack)ItemStack.EMPTY)) {
            return;
        }
        Item item = player.getMainHandItem().getItem();
        if (item instanceof IExtendedReach) {
            IExtendedReach theExtendedReachWeapon = (IExtendedReach)item;
            double distanceSq = player.distanceToSqr(theEntity);
            double reachSq = theExtendedReachWeapon.getReach() * theExtendedReachWeapon.getReach();
            if (reachSq >= distanceSq) {
                player.attack(theEntity);
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

