/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.item.KeychainItem;
import online.kingdomkeys.kingdomkeys.network.Packet;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncPlayerData;
import online.kingdomkeys.kingdomkeys.util.Utils;

public record CSLevelUpKeybladePacket(ItemStack stack) implements Packet
{
    public static final CustomPacketPayload.Type<CSLevelUpKeybladePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"cs_level_up_keyblade"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CSLevelUpKeybladePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, CSLevelUpKeybladePacket::stack, CSLevelUpKeybladePacket::new);

    @Override
    public void handle(IPayloadContext context) {
        Player player = context.player();
        PlayerData playerData = PlayerData.get(player);
        ItemStack stack = this.stack().copy();
        KeychainItem kcItem = (KeychainItem)stack.getItem();
        KeybladeItem item = kcItem.getKeyblade();
        Iterator<Map.Entry<Item, Integer>> itMats = item.data.getLevelData(item.getKeybladeLevel(stack)).getMaterialList().entrySet().iterator();
        boolean hasMaterials = true;
        while (itMats.hasNext()) {
            Map.Entry<Item, Integer> m = itMats.next();
            if (playerData.getMaterialAmount(m.getKey()) >= m.getValue()) continue;
            hasMaterials = false;
        }
        if (hasMaterials) {
            UUID uUID;
            Object object;
            ItemStack itemStack;
            for (Map.Entry entry : item.data.getLevelData(item.getKeybladeLevel(stack)).getMaterialList().entrySet()) {
                playerData.removeMaterial((Item)entry.getKey(), (Integer)entry.getValue());
            }
            kcItem.setKeybladeLevel(stack, kcItem.getKeybladeLevel(stack) + 1);
            int id = Utils.findSummoned(player.getInventory(), stack);
            if (id > -1 && (itemStack = player.getInventory().getItem(id)) != null && (object = itemStack.getItem()) instanceof KeybladeItem) {
                KeybladeItem kbItem = (KeybladeItem)object;
                kbItem.setKeybladeLevel(itemStack, kcItem.getKeybladeLevel(stack));
            }
            if ((uUID = Utils.getKeybladeID(stack)) != null) {
                ResourceLocation slot = null;
                for (Map.Entry entry : playerData.getEquippedKeychains().entrySet()) {
                    if (!uUID.equals(Utils.getKeybladeID((ItemStack)entry.getValue()))) continue;
                    slot = (ResourceLocation)entry.getKey();
                }
                if (slot != null) {
                    playerData.equipKeychain(slot, stack);
                } else {
                    player.getInventory().setItem(player.getInventory().findSlotMatchingItem(this.stack()), stack);
                }
            }
        }
        PacketHandler.sendTo(new SCSyncPlayerData(player), (ServerPlayer)player);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

