/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.network.Packet;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncPlayerData;

public record CSPartyInvite(Party party, UUID playerUUID) implements Packet
{
    public static final CustomPacketPayload.Type<CSPartyInvite> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"cs_party_invite"));
    public static final StreamCodec<FriendlyByteBuf, CSPartyInvite> STREAM_CODEC = StreamCodec.composite(Party.STREAM_CODEC, CSPartyInvite::party, (StreamCodec)UUIDUtil.STREAM_CODEC, CSPartyInvite::playerUUID, CSPartyInvite::new);

    @Override
    public void handle(IPayloadContext context) {
        Player player = context.player();
        Player target = player.level().getPlayerByUUID(this.playerUUID);
        PlayerData targetPlayerData = PlayerData.get(target);
        if (!targetPlayerData.getPartiesInvited().contains(this.party.getName())) {
            targetPlayerData.addPartiesInvited(this.party.getName());
            target.sendSystemMessage((Component)Component.translatable((String)(String.valueOf(ChatFormatting.YELLOW) + "You got an invitation to " + this.party.getName())));
        }
        PacketHandler.sendTo(new SCSyncPlayerData(target), (ServerPlayer)target);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

