/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import online.kingdomkeys.kingdomkeys.data.WorldData;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.network.Packet;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncWorldData;

public record CSPartySettings(Party party) implements Packet
{
    public static final CustomPacketPayload.Type<CSPartySettings> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"cs_party_settings"));
    public static final StreamCodec<FriendlyByteBuf, CSPartySettings> STREAM_CODEC = StreamCodec.composite(Party.STREAM_CODEC, CSPartySettings::party, CSPartySettings::new);

    @Override
    public void handle(IPayloadContext context) {
        Player player = context.player();
        WorldData worldData = WorldData.get(player.getServer());
        Party p = worldData.getPartyFromName(this.party.getName());
        p.setPriv(this.party.getPriv());
        p.setSize(this.party.getSize());
        p.setFriendlyFire(this.party.getFriendlyFire());
        PacketHandler.sendToAll(new SCSyncWorldData(player.getServer()));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

