/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import online.kingdomkeys.kingdomkeys.entity.block.PedestalTileEntity;
import online.kingdomkeys.kingdomkeys.network.Packet;
import online.kingdomkeys.kingdomkeys.util.StreamCodecs;

public record CSPedestalConfig(BlockPos tileEntityPos, float rotationSpeed, float bobSpeed, float savedRotation, float savedHeight, float baseHeight, float scale, boolean pause, boolean flipped) implements Packet
{
    public static final CustomPacketPayload.Type<CSPedestalConfig> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"cs_pedestal_config"));
    public static final StreamCodec<FriendlyByteBuf, CSPedestalConfig> STREAM_CODEC = StreamCodecs.composite(BlockPos.STREAM_CODEC, CSPedestalConfig::tileEntityPos, ByteBufCodecs.FLOAT, CSPedestalConfig::rotationSpeed, ByteBufCodecs.FLOAT, CSPedestalConfig::bobSpeed, ByteBufCodecs.FLOAT, CSPedestalConfig::savedRotation, ByteBufCodecs.FLOAT, CSPedestalConfig::savedHeight, ByteBufCodecs.FLOAT, CSPedestalConfig::baseHeight, ByteBufCodecs.FLOAT, CSPedestalConfig::scale, ByteBufCodecs.BOOL, CSPedestalConfig::pause, ByteBufCodecs.BOOL, CSPedestalConfig::flipped, CSPedestalConfig::new);

    @Override
    public void handle(IPayloadContext context) {
        Level world = context.player().level();
        PedestalTileEntity tileEntity = (PedestalTileEntity)world.getBlockEntity(this.tileEntityPos);
        tileEntity.setSpeed(this.rotationSpeed, this.bobSpeed);
        tileEntity.saveTransforms(this.savedRotation, this.savedHeight);
        tileEntity.setScale(this.scale);
        tileEntity.setPause(this.pause);
        tileEntity.setFlipped(this.flipped);
        tileEntity.setBaseHeight(this.baseHeight);
        world.sendBlockUpdated(this.tileEntityPos, world.getBlockState(this.tileEntityPos), world.getBlockState(this.tileEntityPos), 2);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

