/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import online.kingdomkeys.kingdomkeys.block.SavePointBlock;
import online.kingdomkeys.kingdomkeys.entity.block.SavepointTileEntity;
import online.kingdomkeys.kingdomkeys.network.Packet;
import online.kingdomkeys.kingdomkeys.world.SavePointStorage;

public record CSSavePointTP(UUID currentSavePoint, UUID destinationSavePoint) implements Packet
{
    public static final CustomPacketPayload.Type<CSSavePointTP> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"cs_save_point_tp"));
    public static final StreamCodec<FriendlyByteBuf, CSSavePointTP> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, CSSavePointTP::currentSavePoint, (StreamCodec)UUIDUtil.STREAM_CODEC, CSSavePointTP::destinationSavePoint, CSSavePointTP::new);

    @Override
    public void handle(IPayloadContext context) {
        ServerPlayer player = (ServerPlayer)context.player();
        SavePointStorage storage = SavePointStorage.getStorage(player.getServer());
        SavepointTileEntity te = (SavepointTileEntity)player.level().getBlockEntity(storage.getSavePoint(this.currentSavePoint).pos());
        SavePointStorage.SavePoint destination = storage.getSavePoint(this.destinationSavePoint);
        if (te != null) {
            if (te.getBlockState().getValue(SavePointBlock.TIER) == SavePointStorage.SavePointType.WARP) {
                player.changeDimension(new DimensionTransition(player.getServer().getLevel(destination.dimension()), new Vec3((double)destination.pos().getX() + 0.5, (double)destination.pos().getY() + 0.07, (double)destination.pos().getZ() + 0.5), Vec3.ZERO, player.getYRot(), player.getXRot(), pEntity -> {}));
            } else if (!storage.getSavePoint(this.currentSavePoint).dimension().equals(destination.dimension())) {
                return;
            }
            player.connection.teleport((double)destination.pos().getX() + 0.5, (double)destination.pos().getY() + 0.07, (double)destination.pos().getZ() + 0.5, player.getYRot(), player.getXRot());
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

