/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.item.ModComponents;
import online.kingdomkeys.kingdomkeys.item.ModItems;
import online.kingdomkeys.kingdomkeys.network.Packet;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncPlayerData;
import online.kingdomkeys.kingdomkeys.util.Utils;

public record CSSetAlignment(Utils.OrgMember alignment) implements Packet
{
    public static final CustomPacketPayload.Type<CSSetAlignment> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"cs_set_alignment"));
    public static final StreamCodec<FriendlyByteBuf, CSSetAlignment> STREAM_CODEC = StreamCodec.composite(Utils.OrgMember.STREAM_CODEC, CSSetAlignment::alignment, CSSetAlignment::new);

    @Override
    public void handle(IPayloadContext context) {
        Player player = context.player();
        PlayerData playerData = PlayerData.get(player);
        playerData.setAlignment(this.alignment);
        Item weapon = null;
        switch (this.alignment) {
            case XEMNAS: {
                weapon = ModItems.malice.get();
                break;
            }
            case XIGBAR: {
                weapon = ModItems.standalone.get();
                break;
            }
            case XALDIN: {
                weapon = ModItems.zephyr.get();
                break;
            }
            case VEXEN: {
                weapon = ModItems.testerZero.get();
                break;
            }
            case LEXAEUS: {
                weapon = ModItems.reticence.get();
                break;
            }
            case ZEXION: {
                weapon = ModItems.blackPrimer.get();
                break;
            }
            case SAIX: {
                weapon = ModItems.newMoon.get();
                break;
            }
            case AXEL: {
                weapon = ModItems.ashes.get();
                break;
            }
            case DEMYX: {
                weapon = ModItems.basicModel.get();
                break;
            }
            case LUXORD: {
                weapon = ModItems.theFool.get();
                break;
            }
            case MARLUXIA: {
                weapon = ModItems.fickleErica.get();
                break;
            }
            case LARXENE: {
                weapon = ModItems.trancheuse.get();
                break;
            }
            case ROXAS: {
                weapon = ModItems.kingdomKey.get();
            }
        }
        if (weapon != null) {
            ItemStack stack = new ItemStack((ItemLike)weapon);
            if (playerData.isWeaponUnlocked(weapon)) {
                playerData.getWeaponsUnlocked().forEach(stack1 -> {
                    if (stack1.is(stack.getItem())) {
                        stack.set(ModComponents.KEYBLADE_ID, (Object)((UUID)stack1.get(ModComponents.KEYBLADE_ID)));
                    }
                });
            } else {
                Utils.createKeybladeID(stack);
            }
            playerData.unlockWeapon(stack);
            playerData.equipWeapon(stack);
            playerData.setActiveDriveForm(DriveForm.NONE.toString());
            PacketHandler.sendTo(new SCSyncPlayerData(player), (ServerPlayer)player);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

