/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import online.kingdomkeys.kingdomkeys.ability.Ability;
import online.kingdomkeys.kingdomkeys.ability.ModAbilities;
import online.kingdomkeys.kingdomkeys.api.event.AbilityEvent;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.network.Packet;
import online.kingdomkeys.kingdomkeys.util.Utils;

public record CSSetEquippedAbilityPacket(String ability, int level) implements Packet
{
    public static final CustomPacketPayload.Type<CSSetEquippedAbilityPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"cs_set_equipped_ability"));
    public static final StreamCodec<FriendlyByteBuf, CSSetEquippedAbilityPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, CSSetEquippedAbilityPacket::ability, (StreamCodec)ByteBufCodecs.INT, CSSetEquippedAbilityPacket::level, CSSetEquippedAbilityPacket::new);

    @Override
    public void handle(IPayloadContext context) {
        ServerPlayer player = (ServerPlayer)context.player();
        PlayerData playerData = PlayerData.get((Player)player);
        boolean cancelled = playerData.isAbilityEquipped(this.ability, this.level) ? ((AbilityEvent.Unequip)NeoForge.EVENT_BUS.post((Event)new AbilityEvent.Unequip((Ability)ModAbilities.registry.get(ResourceLocation.parse((String)this.ability)), this.level, (Player)player, false))).isCanceled() : ((AbilityEvent.Equip)NeoForge.EVENT_BUS.post((Event)new AbilityEvent.Equip((Ability)ModAbilities.registry.get(ResourceLocation.parse((String)this.ability)), this.level, (Player)player, false))).isCanceled();
        if (!cancelled) {
            playerData.equipAbilityToggle(this.ability, this.level);
            Utils.RefreshAbilityAttributes((Player)player, playerData);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

