/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import online.kingdomkeys.kingdomkeys.data.WorldData;
import online.kingdomkeys.kingdomkeys.entity.block.OrgPortalTileEntity;
import online.kingdomkeys.kingdomkeys.network.Packet;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncWorldData;

public record CSSetOrgPortalName(BlockPos pos, String name) implements Packet
{
    public static final CustomPacketPayload.Type<CSSetOrgPortalName> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"cs_set_org_portal_name"));
    public static final StreamCodec<FriendlyByteBuf, CSSetOrgPortalName> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, CSSetOrgPortalName::pos, (StreamCodec)ByteBufCodecs.STRING_UTF8, CSSetOrgPortalName::name, CSSetOrgPortalName::new);

    @Override
    public void handle(IPayloadContext context) {
        BlockEntity blockEntity;
        Player player = context.player();
        if (player.level().getBlockEntity(this.pos) != null && (blockEntity = player.level().getBlockEntity(this.pos)) instanceof OrgPortalTileEntity) {
            OrgPortalTileEntity te = (OrgPortalTileEntity)blockEntity;
            UUID portalUUID = te.getUUID();
            WorldData.get(player.getServer()).getPortalFromUUID(portalUUID).setName(this.name);
            PacketHandler.sendTo(new SCSyncWorldData(player.getServer()), (ServerPlayer)player);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

