/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.entity.organization.OrgPortalEntity;
import online.kingdomkeys.kingdomkeys.network.Packet;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncOrgPortalPacket;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncPlayerData;

public record CSSpawnOrgPortalPacket(BlockPos pos, BlockPos destPos, ResourceKey<Level> dimension) implements Packet
{
    public static final CustomPacketPayload.Type<CSSpawnOrgPortalPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"cs_spawn_org_portal"));
    public static final StreamCodec<FriendlyByteBuf, CSSpawnOrgPortalPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, CSSpawnOrgPortalPacket::pos, (StreamCodec)BlockPos.STREAM_CODEC, CSSpawnOrgPortalPacket::destPos, (StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.DIMENSION), CSSpawnOrgPortalPacket::dimension, CSSpawnOrgPortalPacket::new);

    @Override
    public void handle(IPayloadContext context) {
        Player player = context.player();
        player.level().playSound(null, this.pos, (SoundEvent)ModSounds.portal.get(), SoundSource.PLAYERS, 2.0f, 1.0f);
        player.level().playSound(null, this.destPos, (SoundEvent)ModSounds.portal.get(), SoundSource.PLAYERS, 2.0f, 1.0f);
        PlayerData playerData = PlayerData.get(player);
        playerData.remMP(300.0);
        PacketHandler.sendTo(new SCSyncPlayerData(player), (ServerPlayer)player);
        OrgPortalEntity portal = new OrgPortalEntity(player.level(), this.pos, this.destPos, this.dimension, true);
        player.level().addFreshEntity((Entity)portal);
        OrgPortalEntity destPortal = new OrgPortalEntity(player.level(), this.destPos.above(), this.destPos, this.dimension, false);
        player.level().addFreshEntity((Entity)destPortal);
        PacketHandler.sendToAll(new SCSyncOrgPortalPacket(this.pos, this.destPos, this.dimension));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

