/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import online.kingdomkeys.kingdomkeys.data.WorldData;
import online.kingdomkeys.kingdomkeys.lib.Struggle;
import online.kingdomkeys.kingdomkeys.network.Packet;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncWorldData;

public record CSStruggleSettings(Struggle struggle) implements Packet
{
    public static final CustomPacketPayload.Type<CSStruggleSettings> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"cs_struggle_settings"));
    public static final StreamCodec<FriendlyByteBuf, CSStruggleSettings> STREAM_CODEC = StreamCodec.composite(Struggle.STREAM_CODEC, CSStruggleSettings::struggle, CSStruggleSettings::new);

    @Override
    public void handle(IPayloadContext context) {
        Player player = context.player();
        WorldData worldData = WorldData.get(player.getServer());
        Struggle p = worldData.getStruggleFromBlockPos(this.struggle.blockPos);
        p.setSize(this.struggle.getSize());
        p.setDamageMult(this.struggle.getDamageMult());
        p.setName(this.struggle.getName());
        p.setC1(this.struggle.c1);
        p.setC2(this.struggle.c2);
        PacketHandler.sendToAll(new SCSyncWorldData(player.getServer()));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

