/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.item.ModComponents;
import online.kingdomkeys.kingdomkeys.item.PauldronItem;
import online.kingdomkeys.kingdomkeys.menu.PauldronInventory;
import online.kingdomkeys.kingdomkeys.network.Packet;
import online.kingdomkeys.kingdomkeys.util.Utils;

public record CSSummonArmor(boolean forceDesummon) implements Packet
{
    public static final CustomPacketPayload.Type<CSSummonArmor> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"cs_summon_armor"));
    public static final StreamCodec<FriendlyByteBuf, CSSummonArmor> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, CSSummonArmor::forceDesummon, CSSummonArmor::new);

    public CSSummonArmor() {
        this(false);
    }

    private static boolean checkAllArmorSlots(Player player, UUID KBArmorUUID, PlayerData playerData) {
        boolean unequipped = false;
        unequipped = CSSummonArmor.checkAndEmptyArmorSlot(36, player, KBArmorUUID, playerData) || unequipped;
        unequipped = CSSummonArmor.checkAndEmptyArmorSlot(37, player, KBArmorUUID, playerData) || unequipped;
        unequipped = CSSummonArmor.checkAndEmptyArmorSlot(38, player, KBArmorUUID, playerData) || unequipped;
        unequipped = CSSummonArmor.checkAndEmptyArmorSlot(39, player, KBArmorUUID, playerData) || unequipped;
        return unequipped;
    }

    private static boolean checkAndEmptyArmorSlot(int i, Player player, UUID KBArmorUUID, PlayerData playerData) {
        if (Utils.hasArmorID(player.getInventory().getItem(i)) && Utils.getArmorID(player.getInventory().getItem(i)).equals(KBArmorUUID)) {
            Utils.desummonArmour(playerData, player, player.getInventory().getItem(i), i, true, false);
            return true;
        }
        return false;
    }

    private static ItemStack getNewItemWithUUID(ItemStack item, UUID uuid) {
        ItemStack newItem = item.copy();
        newItem.setDamageValue(item.getDamageValue());
        newItem.set(ModComponents.ARMOR_ID, (Object)uuid);
        return newItem;
    }

    private static void spawnArmorParticles(Player summoner) {
        Vec3 userPos = new Vec3(summoner.getX(), summoner.getY(), summoner.getZ());
        ((ServerLevel)summoner.level()).sendParticles((ParticleOptions)ParticleTypes.FIREWORK, userPos.x, summoner.getY() + 1.0, userPos.z, 300, 0.0, 0.0, 0.0, 0.2);
    }

    @Override
    public void handle(IPayloadContext context) {
        Player player = context.player();
        PlayerData playerData = PlayerData.get(player);
        ItemStack kbArmorItem = playerData.getEquippedKBArmor(0);
        if (ItemStack.isSameItem((ItemStack)kbArmorItem, (ItemStack)ItemStack.EMPTY)) {
            return;
        }
        PauldronInventory pauldronInventory = (PauldronInventory)((Object)kbArmorItem.getCapability(Capabilities.ItemHandler.ITEM));
        int checkSlots = pauldronInventory.getSlots();
        for (int i = 0; i < pauldronInventory.getSlots(); ++i) {
            if (!pauldronInventory.getStackInSlot(i).isEmpty()) continue;
            --checkSlots;
        }
        if (kbArmorItem.getItem() == Items.AIR) {
            return;
        }
        Item item = kbArmorItem.getItem();
        if (item instanceof PauldronItem) {
            PauldronItem kbArmor = (PauldronItem)item;
            UUID KBArmorUUID = (UUID)kbArmorItem.get(ModComponents.ARMOR_ID);
            ItemStack[] armor = new ItemStack[]{player.getInventory().getArmor(3), player.getInventory().getArmor(2), player.getInventory().getArmor(1), player.getInventory().getArmor(0)};
            int correctArmor = 0;
            for (ItemStack stack : armor) {
                if (stack.getItem() == Items.AIR || !Utils.hasArmorID(stack) || !Utils.getArmorID(stack).equals(KBArmorUUID)) continue;
                ++correctArmor;
            }
            boolean hasRoom = true;
            if (this.forceDesummon) {
                CSSummonArmor.checkAllArmorSlots(player, KBArmorUUID, playerData);
            } else if (correctArmor == checkSlots) {
                for (int i = 36; i < 40; ++i) {
                    Utils.desummonArmour(playerData, player, player.getInventory().getItem(i), i, true, false);
                }
                player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.unsummon_armor.get(), SoundSource.MASTER, 0.4f, 1.0f);
            } else {
                if (armor[0].getItem() != Items.AIR || armor[1].getItem() != Items.AIR || armor[2].getItem() != Items.AIR || armor[3].getItem() != Items.AIR) {
                    int i;
                    if (CSSummonArmor.checkAllArmorSlots(player, KBArmorUUID, playerData)) {
                        player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.unsummon_armor.get(), SoundSource.MASTER, 0.4f, 1.0f);
                    }
                    armor = new ItemStack[]{player.getInventory().getArmor(3), player.getInventory().getArmor(2), player.getInventory().getArmor(1), player.getInventory().getArmor(0)};
                    int otherArmor = 0;
                    for (i = 0; i < armor.length; ++i) {
                        if (armor[i].getItem() == Items.AIR) continue;
                        ++otherArmor;
                    }
                    if (Utils.getFreeSlotsForPlayer(player) >= otherArmor) {
                        for (i = 0; i < armor.length; ++i) {
                            if (armor[i].getItem() == Items.AIR) continue;
                            Utils.swapStack(player.getInventory(), player.getInventory().getFreeSlot(), 39 - i);
                        }
                    } else {
                        hasRoom = false;
                    }
                    if ((armor = new ItemStack[]{player.getInventory().getArmor(3), player.getInventory().getArmor(2), player.getInventory().getArmor(1), player.getInventory().getArmor(0)})[0].getItem() != Items.AIR || armor[1].getItem() != Items.AIR || armor[2].getItem() != Items.AIR || armor[3].getItem() != Items.AIR) {
                        player.displayClientMessage((Component)Component.translatable((String)"gui.summonarmor.notenoughspace"), true);
                    }
                }
                if (hasRoom) {
                    ItemStack newHelmet = CSSummonArmor.getNewItemWithUUID(pauldronInventory.getStackInSlot(0), KBArmorUUID);
                    ItemStack newChestplate = CSSummonArmor.getNewItemWithUUID(pauldronInventory.getStackInSlot(1), KBArmorUUID);
                    ItemStack newLeggings = CSSummonArmor.getNewItemWithUUID(pauldronInventory.getStackInSlot(2), KBArmorUUID);
                    ItemStack newBoots = CSSummonArmor.getNewItemWithUUID(pauldronInventory.getStackInSlot(3), KBArmorUUID);
                    player.getInventory().setItem(39, newHelmet);
                    player.getInventory().setItem(38, newChestplate);
                    player.getInventory().setItem(37, newLeggings);
                    player.getInventory().setItem(36, newBoots);
                    player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.summon_armor.get(), SoundSource.MASTER, 0.4f, 1.0f);
                    CSSummonArmor.spawnArmorParticles(player);
                }
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

