/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.item.ItemTossEvent;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import online.kingdomkeys.kingdomkeys.api.item.IKeychain;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.item.organization.IOrgWeapon;
import online.kingdomkeys.kingdomkeys.network.Packet;
import online.kingdomkeys.kingdomkeys.util.Utils;

public record CSSummonKeyblade(ResourceLocation formToSummonFrom, boolean forceDesummon) implements Packet
{
    public static final CustomPacketPayload.Type<CSSummonKeyblade> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"cs_summon_keyblade"));
    public static final StreamCodec<FriendlyByteBuf, CSSummonKeyblade> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, CSSummonKeyblade::formToSummonFrom, (StreamCodec)ByteBufCodecs.BOOL, CSSummonKeyblade::forceDesummon, CSSummonKeyblade::new);

    public CSSummonKeyblade() {
        this(DriveForm.NONE, false);
    }

    public CSSummonKeyblade(boolean forceDesummon) {
        this(DriveForm.NONE, forceDesummon);
    }

    public CSSummonKeyblade(ResourceLocation formToSummonFrom) {
        this(formToSummonFrom, false);
    }

    @Override
    public void handle(IPayloadContext context) {
        Player player = context.player();
        Utils.summonKeyblade(player, this.forceDesummon, this.formToSummonFrom);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @EventBusSubscriber
    public static class Events {
        @SubscribeEvent
        public static void containerClose(PlayerContainerEvent.Close event) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            AbstractContainerMenu openContainer = event.getContainer();
            InventoryMenu playerContainer = player.inventoryMenu;
            PlayerData playerData = PlayerData.get((Player)player);
            if (playerData != null && !openContainer.equals(playerContainer)) {
                openContainer.slots.forEach(slot -> {
                    ItemStack stack = slot.getItem();
                    if (!(stack.getItem() instanceof IKeychain) && slot.container != player.getInventory() && Utils.hasKeybladeID(stack)) {
                        slot.set(ItemStack.EMPTY);
                        if (stack.getItem() instanceof IOrgWeapon || playerData.getAlignment() != Utils.OrgMember.NONE) {
                            Set<ItemStack> weapons = playerData.getWeaponsUnlocked();
                            for (ItemStack weapon : weapons) {
                                if (!ItemStack.isSameItem((ItemStack)weapon, (ItemStack)stack)) continue;
                                weapon.applyComponents(stack.getComponents());
                                break;
                            }
                            playerData.setWeaponsUnlocked(weapons);
                        }
                        openContainer.broadcastChanges();
                        player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.unsummon.get(), SoundSource.MASTER, 1.0f, 1.0f);
                    }
                });
            }
        }

        @SubscribeEvent
        public static void dropItem(ItemTossEvent event) {
            ItemStack droppedItem = event.getEntity().getItem();
            Player player = event.getPlayer();
            PlayerData playerData = PlayerData.get(player);
            if (playerData != null && droppedItem != null && !(droppedItem.getItem() instanceof IKeychain) && Utils.hasKeybladeID(droppedItem)) {
                if (playerData.getEquippedWeapon() != null && (droppedItem.getItem() instanceof IOrgWeapon || droppedItem.getItem() instanceof KeybladeItem && playerData.getAlignment() != Utils.OrgMember.NONE || playerData.getEquippedWeapon().getItem() == droppedItem.getItem())) {
                    Set<ItemStack> weapons = playerData.getWeaponsUnlocked();
                    for (ItemStack weapon : weapons) {
                        if (!ItemStack.isSameItem((ItemStack)weapon, (ItemStack)droppedItem)) continue;
                        weapon.applyComponents(droppedItem.getComponents());
                        break;
                    }
                    playerData.setWeaponsUnlocked(weapons);
                }
                player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.unsummon.get(), SoundSource.MASTER, 1.0f, 1.0f);
                event.setCanceled(true);
            }
        }
    }
}

