/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.data.WorldData;
import online.kingdomkeys.kingdomkeys.entity.SpawningMode;
import online.kingdomkeys.kingdomkeys.item.KeychainItem;
import online.kingdomkeys.kingdomkeys.lib.Strings;
import online.kingdomkeys.kingdomkeys.network.Packet;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCShowMessagesPacket;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncPlayerData;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncWorldData;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.Recipe;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.RecipeRegistry;
import online.kingdomkeys.kingdomkeys.util.Utils;

public record CSSynthesiseRecipe(ResourceLocation name) implements Packet
{
    public static final CustomPacketPayload.Type<CSSynthesiseRecipe> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"cs_synthesis_recipe"));
    public static final StreamCodec<FriendlyByteBuf, CSSynthesiseRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, CSSynthesiseRecipe::name, CSSynthesiseRecipe::new);

    @Override
    public void handle(IPayloadContext context) {
        Player player = context.player();
        if (player.getInventory().getFreeSlot() > -1) {
            PlayerData playerData = PlayerData.get(player);
            Recipe recipe = RecipeRegistry.getInstance().getValue(this.name);
            int stacksToGive = Utils.stacksForItemAmount(new ItemStack((ItemLike)recipe.getResult()), recipe.getAmount());
            if (stacksToGive <= Utils.getFreeSlotsForPlayer(player)) {
                boolean enoughTier;
                Iterator<Map.Entry<Item, Integer>> it = recipe.getMaterials().entrySet().iterator();
                boolean hasMaterials = true;
                boolean enoughMunny = playerData.getMunny() >= recipe.getCost();
                boolean bl = enoughTier = (Boolean)ModConfigs.SERVER.requireSynthTier.get() == false || playerData.getSynthLevel() >= recipe.getTier();
                while (it.hasNext()) {
                    Map.Entry<Item, Integer> m = it.next();
                    if (playerData.getMaterialAmount(m.getKey()) >= m.getValue()) continue;
                    hasMaterials = false;
                }
                if (hasMaterials && enoughMunny && enoughTier) {
                    playerData.setMunny(playerData.getMunny() - recipe.getCost());
                    playerData.addSynthExperience(10 + recipe.getTier() * 2);
                    for (Map.Entry entry : recipe.getMaterials().entrySet()) {
                        playerData.removeMaterial((Item)entry.getKey(), (Integer)entry.getValue());
                    }
                    Item i = recipe.getResult();
                    ItemStack itemStack = new ItemStack((ItemLike)i);
                    for (int s = 0; s < stacksToGive - 1; ++s) {
                        player.getInventory().add(new ItemStack((ItemLike)i, itemStack.getMaxStackSize()));
                    }
                    int remainder = recipe.getAmount() - (stacksToGive - 1) * itemStack.getMaxStackSize();
                    if (remainder > 0) {
                        player.getInventory().add(new ItemStack((ItemLike)i, remainder));
                    }
                    if (i instanceof KeychainItem && ModConfigs.heartlessSpawningMode == SpawningMode.AFTER_KEYCHAIN) {
                        WorldData worldData = WorldData.get(player.getServer());
                        if (worldData.getHeartlessSpawnLevel() == 0) {
                            List<Utils.Title> titles = List.of(new Utils.Title("", Strings.HeartlessIntro1), new Utils.Title("", Strings.HeartlessIntro2), new Utils.Title("", Strings.HeartlessIntro3));
                            PacketHandler.sendToAll(new SCShowMessagesPacket(titles));
                            Utils.playSoundToEveryone((ServerLevel)player.level(), SoundEvents.WITHER_SPAWN, 1.0f, 1.0f);
                        }
                        worldData.setHeartlessSpawnLevel(1);
                        PacketHandler.sendToAll(new SCSyncWorldData(player.getServer()));
                    }
                    playerData.addSynthesisedRecipe(this.name.toString());
                }
                PacketHandler.sendTo(new SCSyncPlayerData(player), (ServerPlayer)player);
            }
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

