/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.network.Packet;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCOpenMaterialsScreen;

public record CSTakeMaterials(ItemStack stack, int amount, String inv, String name, int moogle) implements Packet
{
    public static final CustomPacketPayload.Type<CSTakeMaterials> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"cs_take_materials"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CSTakeMaterials> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, CSTakeMaterials::stack, (StreamCodec)ByteBufCodecs.INT, CSTakeMaterials::amount, (StreamCodec)ByteBufCodecs.STRING_UTF8, CSTakeMaterials::inv, (StreamCodec)ByteBufCodecs.STRING_UTF8, CSTakeMaterials::name, (StreamCodec)ByteBufCodecs.INT, CSTakeMaterials::moogle, CSTakeMaterials::new);

    @Override
    public void handle(IPayloadContext context) {
        Player player = context.player();
        PlayerData playerData = PlayerData.get(player);
        if (!ItemStack.isSameItem((ItemStack)this.stack, (ItemStack)ItemStack.EMPTY)) {
            int amountToTake = this.amount;
            if (playerData.getMaterialAmount(this.stack.getItem()) < this.amount) {
                amountToTake = playerData.getMaterialAmount(this.stack.getItem());
            }
            ItemStack toAdd = this.stack.copy();
            toAdd.setCount(amountToTake);
            playerData.removeMaterial(this.stack.getItem(), amountToTake);
            player.getInventory().add(toAdd);
        }
        PacketHandler.sendTo(new SCOpenMaterialsScreen(playerData.serializeNBT((HolderLookup.Provider)player.level().registryAccess()), this.inv, this.name, this.moogle), (ServerPlayer)player);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

