/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import online.kingdomkeys.kingdomkeys.api.event.EquipmentEvent;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.item.ModComponents;
import online.kingdomkeys.kingdomkeys.network.Packet;

public record CSUnlockEquipOrgWeapon(ItemStack weapon, int cost, boolean unlock) implements Packet
{
    public static final CustomPacketPayload.Type<CSUnlockEquipOrgWeapon> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"cs_unlock_equip_org_weapon"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CSUnlockEquipOrgWeapon> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, CSUnlockEquipOrgWeapon::weapon, (StreamCodec)ByteBufCodecs.INT, CSUnlockEquipOrgWeapon::cost, (StreamCodec)ByteBufCodecs.BOOL, CSUnlockEquipOrgWeapon::unlock, CSUnlockEquipOrgWeapon::new);

    public CSUnlockEquipOrgWeapon(ItemStack weapon, int cost) {
        this(weapon, cost, true);
    }

    public CSUnlockEquipOrgWeapon(ItemStack weapon) {
        this(weapon, 0, false);
    }

    @Override
    public void handle(IPayloadContext context) {
        Player player = context.player();
        PlayerData playerData = PlayerData.get(player);
        if (this.unlock) {
            if (playerData.getHearts() >= this.cost) {
                this.weapon.set(ModComponents.KEYBLADE_ID, (Object)UUID.randomUUID());
                playerData.unlockWeapon(this.weapon);
                playerData.removeHearts(this.cost);
            }
        } else if (playerData.isWeaponUnlocked(this.weapon.getItem())) {
            playerData.getWeaponsUnlocked().forEach(itemStack -> {
                if (itemStack.is(this.weapon.getItem()) && !((EquipmentEvent.OrgWeapon)NeoForge.EVENT_BUS.post((Event)new EquipmentEvent.OrgWeapon(player, playerData.getEquippedWeapon(), (ItemStack)itemStack))).isCanceled()) {
                    playerData.equipWeapon((ItemStack)itemStack);
                }
            });
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

