/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.magic.Magic;
import online.kingdomkeys.kingdomkeys.magic.ModMagic;
import online.kingdomkeys.kingdomkeys.network.Packet;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncPlayerData;
import online.kingdomkeys.kingdomkeys.util.Utils;

public record CSUseMagicPacket(String name, int level, String allyTarget, int lockedTarget) implements Packet
{
    public static final CustomPacketPayload.Type<CSUseMagicPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"cs_use_magic"));
    public static final StreamCodec<FriendlyByteBuf, CSUseMagicPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, CSUseMagicPacket::name, (StreamCodec)ByteBufCodecs.INT, CSUseMagicPacket::level, (StreamCodec)ByteBufCodecs.STRING_UTF8, CSUseMagicPacket::allyTarget, (StreamCodec)ByteBufCodecs.INT, CSUseMagicPacket::lockedTarget, CSUseMagicPacket::new);

    public CSUseMagicPacket(String name, int level, LivingEntity lockedTarget) {
        this(name, level, "", lockedTarget == null ? -1 : lockedTarget.getId());
    }

    public CSUseMagicPacket(String name, String target, int level) {
        this(name, level, target, -1);
    }

    @Override
    public void handle(IPayloadContext context) {
        Player player = context.player();
        PlayerData playerData = PlayerData.get(player);
        if (playerData.getMP() >= 0.0 && !playerData.getRecharge()) {
            PacketHandler.sendTo(new SCSyncPlayerData(player), (ServerPlayer)player);
            if (this.allyTarget.equals("")) {
                if (this.lockedTarget > -1) {
                    ((Magic)ModMagic.registry.get(ResourceLocation.parse((String)this.name))).onUse(player, player, this.level, (LivingEntity)player.level().getEntity(this.lockedTarget));
                } else {
                    ((Magic)ModMagic.registry.get(ResourceLocation.parse((String)this.name))).onUse(player, player, this.level, null);
                }
            } else {
                Player allyTargetEntity = Utils.getPlayerByName(player.level(), this.allyTarget.toLowerCase());
                ((Magic)ModMagic.registry.get(ResourceLocation.parse((String)this.name))).onUse(allyTargetEntity, player, this.level, null);
            }
        }
        PacketHandler.syncToAllAround(player, playerData);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

