/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.effects.ModMobEffects;
import online.kingdomkeys.kingdomkeys.magic.Magic;
import online.kingdomkeys.kingdomkeys.magic.ModMagic;
import online.kingdomkeys.kingdomkeys.network.Packet;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncPlayerData;

public record CSUseShortcutPacket(int index, int lockOnTarget) implements Packet
{
    public static final CustomPacketPayload.Type<CSUseShortcutPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"cs_use_shortcut"));
    public static final StreamCodec<FriendlyByteBuf, CSUseShortcutPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, CSUseShortcutPacket::index, (StreamCodec)ByteBufCodecs.INT, CSUseShortcutPacket::lockOnTarget, CSUseShortcutPacket::new);

    public CSUseShortcutPacket(int index, LivingEntity lockOnTarget) {
        this(index, lockOnTarget == null ? -1 : lockOnTarget.getId());
    }

    @Override
    public void handle(IPayloadContext context) {
        Player player = context.player();
        PlayerData playerData = PlayerData.get(player);
        if (playerData == null) {
            return;
        }
        if (playerData.getMagicCooldownTicks() <= 0 && !playerData.getRecharge() && !playerData.getActiveDriveForm().equals("kingdomkeys:form_valor") && !player.hasEffect(ModMobEffects.KO) && playerData.getShortcutsMap().containsKey(this.index)) {
            String[] data = playerData.getShortcutsMap().get(this.index).split(",");
            String magicName = data[0];
            int level = Integer.parseInt(data[1]);
            Magic magic = (Magic)ModMagic.registry.get(ResourceLocation.parse((String)magicName));
            double cost = magic.getCost(level, player);
            if (!(playerData.getMaxMP() == 0.0 || playerData.getRecharge() || cost > playerData.getMaxMP() && cost < 300.0 || cost < 300.0 && cost >= playerData.getMP() && playerData.isAbilityEquipped("kingdomkeys:ability_mp_safety") || playerData.getMagicCooldownTicks() > 0)) {
                magic.onUse(player, player, level, (LivingEntity)player.level().getEntity(this.lockOnTarget));
            }
            PacketHandler.sendTo(new SCSyncPlayerData(player), (ServerPlayer)player);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

