/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.stc;

import com.mojang.datafixers.util.Pair;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import online.kingdomkeys.kingdomkeys.client.ClientPacketHandler;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.entity.block.SavepointTileEntity;
import online.kingdomkeys.kingdomkeys.network.Packet;
import online.kingdomkeys.kingdomkeys.util.StreamCodecs;
import online.kingdomkeys.kingdomkeys.world.SavePointStorage;

public record SCOpenSavePointScreen(BlockPos tileEntity, Map<UUID, Pair<SavePointStorage.SavePoint, Instant>> savePoints, boolean create) implements Packet
{
    public static final CustomPacketPayload.Type<SCOpenSavePointScreen> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"sc_open_save_point_screen"));
    public static final StreamCodec<FriendlyByteBuf, SCOpenSavePointScreen> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, SCOpenSavePointScreen::tileEntity, StreamCodecs.SAVE_POINTS, SCOpenSavePointScreen::savePoints, (StreamCodec)ByteBufCodecs.BOOL, SCOpenSavePointScreen::create, SCOpenSavePointScreen::new);

    public SCOpenSavePointScreen(SavepointTileEntity tileEntity, Player player) {
        this(tileEntity.getBlockPos(), SCOpenSavePointScreen.getAndAddSavePoints(tileEntity, player), SCOpenSavePointScreen.shouldCreate(tileEntity, player));
    }

    public static Map<UUID, Pair<SavePointStorage.SavePoint, Instant>> readSavePoints(FriendlyByteBuf buf) {
        HashMap<UUID, Pair<SavePointStorage.SavePoint, Instant>> points = new HashMap<UUID, Pair<SavePointStorage.SavePoint, Instant>>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            SavePointStorage.SavePoint savePoint = new SavePointStorage.SavePoint(buf.readNbt());
            points.put(savePoint.id(), (Pair<SavePointStorage.SavePoint, Instant>)Pair.of((Object)savePoint, (Object)Instant.ofEpochSecond(buf.readLong(), buf.readInt())));
        }
        return points;
    }

    private static Map<UUID, Pair<SavePointStorage.SavePoint, Instant>> getAndAddSavePoints(SavepointTileEntity tileEntity, Player player) {
        SavePointStorage storage = SavePointStorage.getStorage(player.getServer());
        Map<UUID, Pair<SavePointStorage.SavePoint, Instant>> savePoints = storage.getDiscoveredSavePoints(player);
        if (storage.savePointRegistered(tileEntity.getID()) && !storage.getSavePoint(tileEntity.getID()).global() && !savePoints.containsKey(tileEntity.getID())) {
            Instant instant = Instant.now();
            savePoints.put(tileEntity.getID(), (Pair<SavePointStorage.SavePoint, Instant>)Pair.of((Object)storage.getSavePoint(tileEntity.getID()), (Object)instant));
            PlayerData.get(player).addDiscoveredSavePoint(tileEntity.getID(), instant);
        }
        return savePoints;
    }

    private static boolean shouldCreate(SavepointTileEntity tileEntity, Player player) {
        SavePointStorage storage = SavePointStorage.getStorage(player.getServer());
        return !storage.savePointRegistered(tileEntity.getID());
    }

    @Override
    public void handle(IPayloadContext context) {
        if (FMLEnvironment.dist.isClient()) {
            ClientPacketHandler.openSavePointScreen(this);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

