/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.reactioncommands;

import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.magic.Magic;
import online.kingdomkeys.kingdomkeys.magic.ModMagic;
import online.kingdomkeys.kingdomkeys.reactioncommands.ReactionCommand;

public class ReactionMagic
extends ReactionCommand {
    ResourceLocation magic;

    public ReactionMagic(ResourceLocation registryName) {
        super(registryName, false);
        this.magic = registryName;
    }

    public String getMagicName() {
        return this.magic.toString();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getTranslationKey() {
        PlayerData playerData = PlayerData.get((Player)Minecraft.getInstance().player);
        int level = playerData.getMagicLevel(this.magic);
        Magic mag = (Magic)ModMagic.registry.get(this.magic);
        ++level;
        if (mag.getGMAbility() != null && playerData.getNumberOfAbilitiesEquipped(mag.getGMAbility().getRegistryName().toString()) > 0) {
            level = mag.getMaxLevel() + 1;
        }
        return "magic." + this.magic.getNamespace() + "." + this.magic.getPath() + level + ".name";
    }

    @Override
    public void onUse(Player player, LivingEntity target, LivingEntity lockedOnEntity) {
        Magic mag = (Magic)ModMagic.registry.get(this.magic);
        PlayerData playerData = PlayerData.get(player);
        int level = playerData.getMagicLevel(this.magic);
        ++level;
        if (mag.getGMAbility() != null && playerData.getNumberOfAbilitiesEquipped(mag.getGMAbility().getRegistryName().toString()) > 0) {
            level = mag.getMaxLevel() + 1;
        }
        mag.onUse(player, player, level, lockedOnEntity);
        playerData.removeReactionCommand(this.getRegistryName().toString());
    }

    @Override
    public boolean conditionsToAppear(Player player, LivingEntity target) {
        return true;
    }
}

