/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.shotlock;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.lib.DamageCalculation;

public abstract class Shotlock {
    ResourceLocation name;
    int order;
    int cooldown;
    int max;
    String translationKey;

    public Shotlock(ResourceLocation registryName, int order, int cooldown, int max) {
        this.name = registryName;
        this.cooldown = cooldown;
        this.max = max;
        this.order = order;
        this.translationKey = "shotlock." + registryName.getPath() + ".name";
    }

    public Shotlock(String registryName, int order, int cooldown, int max) {
        this(ResourceLocation.parse((String)registryName), order, cooldown, max);
    }

    public String getName() {
        return this.name.toString();
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public int getOrder() {
        return this.order;
    }

    public int getMaxLocks() {
        return this.max;
    }

    public void onUse(Player player, List<Entity> targetList) {
        if (targetList.size() == this.getMaxLocks()) {
            this.doFullShotlock(player, targetList);
        } else {
            this.doPartialShotlock(player, targetList);
        }
    }

    public ResourceLocation getRegistryName() {
        return this.name;
    }

    public float getDamage(Player player) {
        return (DamageCalculation.getMagicDamage(player) * 0.7f + DamageCalculation.getStrengthDamage(player) * 0.3f) * (float)ModConfigs.shotlockMult;
    }

    public abstract void doPartialShotlock(Player var1, List<Entity> var2);

    public abstract void doFullShotlock(Player var1, List<Entity> var2);
}

