/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.sound;

import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.util.Utils;

@OnlyIn(value=Dist.CLIENT)
public class AlarmSoundInstance
extends AbstractTickableSoundInstance {
    private static final float VOLUME_MIN = 0.0f;
    private static final float VOLUME_MAX = 0.7f;
    private static final float PITCH_MIN = 0.0f;
    private static final float PITCH_MAX = 1.0f;
    private static final float PITCH_DELTA = 0.0025f;
    private final Player player;
    private float pitch = 0.0f;

    public AlarmSoundInstance(Player player) {
        super((SoundEvent)ModSounds.alarm.get(), SoundSource.PLAYERS, SoundInstance.createUnseededRandom());
        this.player = player;
        this.looping = true;
        this.delay = 0;
        this.volume = 0.0f;
        this.x = (float)player.getX();
        this.y = (float)player.getY();
        this.z = (float)player.getZ();
    }

    public boolean canPlaySound() {
        return true;
    }

    public boolean canStartSilent() {
        return true;
    }

    public void tick() {
        if (this.player.isRemoved()) {
            this.stop();
        } else if (!Utils.isPlayerLowHP(this.player)) {
            this.volume = 0.0f;
        } else {
            this.x = (float)this.player.getX();
            this.y = (float)this.player.getY();
            this.z = (float)this.player.getZ();
            this.pitch = 1.0f;
            this.volume = (float)ModConfigs.hpAlarm / 10.0f;
        }
    }
}

