/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.synthesis.recipe;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class Recipe {
    @Nullable
    Map<Item, Integer> materials;
    @Nullable
    Item result;
    @Nullable
    int amount;
    @Nullable
    String type;
    @Nullable
    int cost;
    @Nullable
    int tier;
    ResourceLocation registryName;
    public static final StreamCodec<FriendlyByteBuf, Recipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.COMPOUND_TAG, Recipe::serializeNBT, Recipe::new);

    public Recipe() {
    }

    public Recipe(Map<Item, Integer> materials, int cost, Item result, int amount, String type) {
        this.materials = materials;
        this.result = result;
        this.amount = amount;
        this.type = type;
        this.cost = cost;
    }

    public Recipe(CompoundTag tag) {
        this.deserializeNBT(tag);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Map<Item, Integer> getMaterials() {
        return this.materials;
    }

    public void setMaterials(Map<Item, Integer> materials) {
        this.materials = materials;
    }

    public Item getResult() {
        return this.result;
    }

    public void setResult(Item result, int amount) {
        this.result = result;
        this.amount = amount;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public int getCost() {
        return this.cost;
    }

    public void setCost(int cost) {
        this.cost = cost;
    }

    public int getTier() {
        return this.tier;
    }

    public void setTier(int tier) {
        this.tier = tier;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.putString("regname", this.getRegistryName().toString());
        nbt.putString("result", BuiltInRegistries.ITEM.getKey((Object)this.result).toString());
        nbt.putInt("amount", this.amount);
        nbt.putInt("cost", this.cost);
        nbt.putInt("tier", this.tier);
        nbt.putString("type", this.getType());
        nbt.putInt("ingredients_size", this.materials.entrySet().size());
        AtomicInteger i = new AtomicInteger();
        this.materials.entrySet().forEach(entry -> {
            nbt.putString("ingredient_material_" + String.valueOf(i), BuiltInRegistries.ITEM.getKey((Object)((Item)entry.getKey())).toString());
            nbt.putInt("ingredient_amount_" + String.valueOf(i), ((Integer)entry.getValue()).intValue());
            i.getAndIncrement();
        });
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.setResult((Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)nbt.getString("result"))), nbt.getInt("amount"));
        this.setType(nbt.getString("type"));
        this.setCost(nbt.getInt("cost"));
        this.setTier(nbt.getInt("tier"));
        HashMap<Item, Integer> ingredients = new HashMap<Item, Integer>();
        for (int i = 0; i < nbt.getInt("ingredients_size"); ++i) {
            ingredients.put((Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)nbt.getString("ingredient_material_" + i))), nbt.getInt("ingredient_amount_" + i));
        }
        this.setMaterials(ingredients);
        this.setRegistryName(nbt.getString("regname"));
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public void setRegistryName(String registryName) {
        this.registryName = ResourceLocation.parse((String)registryName);
    }

    public void setRegistryName(String namespace, String path) {
        this.registryName = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
    }

    public void setRegistryName(ResourceLocation registryName) {
        this.registryName = registryName;
    }
}

