/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.synthesis.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.Recipe;
import org.jetbrains.annotations.NotNull;

public class RecipeDataDeserializer
implements JsonDeserializer<Recipe> {
    public Recipe deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Recipe out = new Recipe();
        JsonObject jsonObject = json.getAsJsonObject();
        jsonObject.entrySet().forEach(entry -> {
            JsonElement element = (JsonElement)entry.getValue();
            switch ((String)entry.getKey()) {
                case "ingredients": {
                    Map<Item, Integer> recipe = RecipeDataDeserializer.getMaterialIntegerMap(json, element);
                    out.setMaterials(recipe);
                    break;
                }
                case "cost": {
                    out.setCost(element.getAsInt());
                    break;
                }
                case "output": {
                    boolean valid;
                    JsonObject outputObject = element.getAsJsonObject();
                    boolean bl = valid = outputObject.get("item") != null && outputObject.get("quantity") != null;
                    if (!valid) break;
                    Item keychain = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)outputObject.get("item").getAsString()));
                    out.setResult(keychain, outputObject.get("quantity").getAsInt());
                    out.setType(outputObject.get("type").getAsString());
                    break;
                }
                case "tier": {
                    out.setTier(element.getAsInt());
                }
            }
        });
        return out;
    }

    @NotNull
    private static Map<Item, Integer> getMaterialIntegerMap(JsonElement json, JsonElement element) {
        HashMap<Item, Integer> recipe = new HashMap<Item, Integer>();
        JsonArray recipeArray = element.getAsJsonArray();
        recipeArray.forEach(ingredient -> {
            boolean valid;
            JsonObject ingredientObject = ingredient.getAsJsonObject();
            Item m = null;
            int quantity = 0;
            boolean bl = valid = ingredientObject.get("material") != null && ingredientObject.get("quantity") != null;
            if (valid) {
                m = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)ingredientObject.get("material").getAsString()));
                if (m == null) {
                    throw new JsonParseException("Material supplied in recipe cannot be found in the registry" + String.valueOf(json));
                }
            } else {
                throw new JsonParseException("Invalid recipe ingredient, missing material/quantity" + String.valueOf(json));
            }
            quantity = ingredientObject.get("quantity").getAsInt();
            recipe.put(m, quantity);
        });
        return recipe;
    }
}

