/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.synthesis.shop;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import online.kingdomkeys.kingdomkeys.synthesis.shop.ShopItem;

public class ShopList {
    List<ShopItem> list = new LinkedList<ShopItem>();
    @Nullable
    ResourceLocation names = null;
    ResourceLocation registryName;
    public static final StreamCodec<FriendlyByteBuf, ShopList> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.COMPOUND_TAG, ShopList::serializeNBT, ShopList::new);

    public ShopList() {
    }

    public ShopList(CompoundTag tag) {
        this.deserializeNBT(tag);
    }

    public ShopList(ResourceLocation rl, List<ShopItem> list, @Nullable List<String> names) {
        this.registryName = rl;
        this.list = list;
    }

    public void setNames(@Nullable ResourceLocation names) {
        this.names = names;
    }

    public ResourceLocation getNames() {
        return this.names;
    }

    public List<ShopItem> getList() {
        return this.list;
    }

    public void setList(List<ShopItem> list) {
        this.list = list;
    }

    public void addToList(ShopItem shopItem) {
        this.list.add(shopItem);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.putString("regname", this.getRegistryName().toString());
        nbt.putInt("len", this.list.size());
        for (int i = 0; i < this.list.size(); ++i) {
            ShopItem shopItem = this.list.get(i);
            nbt.put("shop_item_" + i, (Tag)shopItem.serializeNBT());
        }
        if (this.names != null) {
            nbt.putString("names", this.names.toString());
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.list.clear();
        for (int i = 0; i < nbt.getInt("len"); ++i) {
            ShopItem shopItem = new ShopItem();
            shopItem.deserializeNBT(nbt.getCompound("shop_item_" + i));
            this.list.add(shopItem);
        }
        this.setRegistryName(nbt.getString("regname"));
        if (nbt.contains("names")) {
            this.setNames(ResourceLocation.parse((String)nbt.getString("names")));
        }
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public void setRegistryName(String registryName) {
        this.registryName = ResourceLocation.parse((String)registryName);
    }

    public void setRegistryName(String namespace, String path) {
        this.registryName = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
    }

    public void setRegistryName(ResourceLocation registryName) {
        this.registryName = registryName;
    }
}

