/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.synthesis.shop;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncShopData;
import online.kingdomkeys.kingdomkeys.synthesis.shop.ShopList;
import online.kingdomkeys.kingdomkeys.synthesis.shop.ShopListDataDeserializer;
import online.kingdomkeys.kingdomkeys.synthesis.shop.ShopListRegistry;

public class ShopListDataLoader
extends SimpleJsonResourceReloadListener {
    public static final Gson GSON_BUILDER = new GsonBuilder().registerTypeAdapter(ShopList.class, (Object)new ShopListDataDeserializer()).setPrettyPrinting().create();

    public ShopListDataLoader() {
        super(GSON_BUILDER, "shop");
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        ShopListRegistry.getInstance().clearRegistry();
        AtomicInteger count = new AtomicInteger();
        objectIn.forEach((resourceLocation, element) -> {
            if (!resourceLocation.getPath().contains("names/")) {
                try {
                    ShopList result = (ShopList)GSON_BUILDER.fromJson(element, ShopList.class);
                    result.setRegistryName((ResourceLocation)resourceLocation);
                    ShopListRegistry.getInstance().register(result);
                    count.incrementAndGet();
                }
                catch (JsonParseException e) {
                    KingdomKeys.LOGGER.error("Error parsing json file {}: {}", resourceLocation, (Object)e);
                }
            }
        });
        KingdomKeys.LOGGER.info("Loaded {} shop data", (Object)count.get());
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayers()) {
                PacketHandler.sendTo(new SCSyncShopData(ShopListRegistry.getInstance().getValues()), player);
            }
        }
    }
}

