/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.synthesis.shop;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.synthesis.shop.ShopList;

public class ShopListRegistry {
    private static ShopListRegistry INSTANCE;
    private Map<ResourceLocation, ShopList> registry = new HashMap<ResourceLocation, ShopList>();

    private ShopListRegistry() {
    }

    public static ShopListRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ShopListRegistry();
        }
        return INSTANCE;
    }

    public void register(ShopList shopList) {
        if (shopList.getRegistryName() != null) {
            this.registry.put(shopList.getRegistryName(), shopList);
            KingdomKeys.LOGGER.debug("Successfully registered Shop list {}", (Object)shopList.getRegistryName());
        } else {
            KingdomKeys.LOGGER.error("Cannot register Shop list with no registry name");
        }
    }

    public ShopList getValue(ResourceLocation key) {
        if (this.containsKey(key)) {
            return this.registry.get(key);
        }
        if (!key.getPath().isEmpty()) {
            KingdomKeys.LOGGER.error("Shop list registry does not contain location: {}", (Object)key);
        }
        return null;
    }

    public boolean containsKey(ResourceLocation key) {
        return this.registry.containsKey(key);
    }

    public void clearRegistry() {
        this.registry.clear();
        KingdomKeys.LOGGER.debug("Shop list registry cleared");
    }

    public Map<ResourceLocation, ShopList> getRegistry() {
        return this.registry;
    }

    public List<ShopList> getValues() {
        return new LinkedList<ShopList>(this.registry.values());
    }

    public void setRegistry(Map<ResourceLocation, ShopList> registry) {
        this.registry = registry;
    }
}

