/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundRemoveMobEffectPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.ability.Ability;
import online.kingdomkeys.kingdomkeys.ability.ModAbilities;
import online.kingdomkeys.kingdomkeys.api.item.IItemCategory;
import online.kingdomkeys.kingdomkeys.api.item.IKeychain;
import online.kingdomkeys.kingdomkeys.api.item.ItemCategory;
import online.kingdomkeys.kingdomkeys.api.item.ItemCategoryRegistry;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.data.GlobalData;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.data.WorldData;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.effects.ModMobEffects;
import online.kingdomkeys.kingdomkeys.item.KKAccessoryItem;
import online.kingdomkeys.kingdomkeys.item.KKArmorItem;
import online.kingdomkeys.kingdomkeys.item.KKResistanceType;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.item.ModComponents;
import online.kingdomkeys.kingdomkeys.item.ModItems;
import online.kingdomkeys.kingdomkeys.item.PauldronItem;
import online.kingdomkeys.kingdomkeys.item.organization.IOrgWeapon;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.lib.SoAState;
import online.kingdomkeys.kingdomkeys.limit.Limit;
import online.kingdomkeys.kingdomkeys.limit.ModLimits;
import online.kingdomkeys.kingdomkeys.magic.Magic;
import online.kingdomkeys.kingdomkeys.magic.ModMagic;
import online.kingdomkeys.kingdomkeys.menu.PauldronInventory;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCRecalculateEyeHeight;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncGlobalData;
import online.kingdomkeys.kingdomkeys.shotlock.ModShotlocks;
import online.kingdomkeys.kingdomkeys.shotlock.Shotlock;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.RecipeRegistry;

public class Utils {
    public static final ResourceLocation mobLevelHPModifier = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"mob_level_hp");
    public static final ResourceLocation mobLevelAttackModifier = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"mob_level_attack");
    static final int[] bagCosts = new int[]{10000, 20000, 40000, 80000};

    public static ItemStack getItemInAnyHand(Player player, Item item) {
        if (!player.getMainHandItem().isEmpty() && player.getMainHandItem().getItem() == item) {
            return player.getMainHandItem();
        }
        if (!player.getOffhandItem().isEmpty() && player.getOffhandItem().getItem() == item) {
            return player.getOffhandItem();
        }
        return null;
    }

    public static int getSavepointPercent(int ticks) {
        return Math.round(100.0f - (float)(ticks - 1) / 19.0f * 100.0f);
    }

    public static ItemStack getWhiteMushroomReward() {
        ArrayList<Item> list = new ArrayList<Item>();
        list.add(ModItems.orichalcum.get());
        list.add(ModItems.orichalcumplus.get());
        list.add(ModItems.evanescent_crystal.get());
        list.add(ModItems.illusory_crystal.get());
        Random rand = new Random();
        Item item = (Item)list.get(rand.nextInt(list.size()));
        return new ItemStack((ItemLike)item, rand.nextInt(3) + 1);
    }

    public static int getCheapestDriveCost(PlayerData playerData, List<DriveForm> driveFormMap) {
        int min = playerData.isAbilityEquipped("kingdomkeys:ability_dark_domination") ? ModDriveForms.ANTI.get().getDriveCost() : 1000;
        for (DriveForm form : driveFormMap) {
            if (form == null || form.getDriveFormData() == null || form == ModDriveForms.ANTI.get()) continue;
            min = Math.min(form.getDriveCost(), min);
        }
        return min;
    }

    public static double getCheapestMagicCost(LinkedHashMap<String, int[]> magicsMap, Player player) {
        double min = 1000.0;
        for (Map.Entry<String, int[]> magic : magicsMap.entrySet()) {
            Magic m = (Magic)ModMagic.registry.get(ResourceLocation.parse((String)magic.getKey()));
            if (m == null) continue;
            int lvl = magic.getValue()[0];
            min = Math.min(m.getCost(lvl, player), min);
        }
        return min;
    }

    public static List<Component> getResistancesStats(ItemStack selectedItemStack) {
        ArrayList<Component> stats = new ArrayList<Component>();
        int str = 0;
        int mag = 0;
        int ap = 0;
        int def = 0;
        int fireRes = 0;
        int iceRes = 0;
        int thunderRes = 0;
        int lightRes = 0;
        int darkRes = 0;
        Item item = selectedItemStack.getItem();
        Objects.requireNonNull(item);
        Item item2 = item;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{KeybladeItem.class, KKAccessoryItem.class, KKArmorItem.class}, (Object)item2, n)) {
            case 0: {
                KeybladeItem kb = (KeybladeItem)item2;
                str = kb.getStrength(0);
                mag = kb.getMagic(0);
                break;
            }
            case 1: {
                KKAccessoryItem accessory = (KKAccessoryItem)item2;
                str = accessory.getStr();
                mag = accessory.getMag();
                ap = accessory.getAp();
                break;
            }
            case 2: {
                KKArmorItem armor = (KKArmorItem)item2;
                def = armor.getDefense();
                for (Map.Entry resistanceType : armor.getResList().entrySet()) {
                    switch ((KKResistanceType)((Object)resistanceType.getKey())) {
                        case fire: {
                            fireRes = (Integer)resistanceType.getValue();
                            break;
                        }
                        case ice: {
                            iceRes = (Integer)resistanceType.getValue();
                            break;
                        }
                        case lightning: {
                            thunderRes = (Integer)resistanceType.getValue();
                            break;
                        }
                        case light: {
                            lightRes = (Integer)resistanceType.getValue();
                            break;
                        }
                        case darkness: {
                            darkRes = (Integer)resistanceType.getValue();
                        }
                    }
                }
                break;
            }
        }
        if (ap != 0) {
            stats.add((Component)Component.literal((String)(Utils.translateToLocal("gui.menu.status.ap", new Object[0]) + ": " + ap)).withStyle(ChatFormatting.YELLOW));
        }
        if (str != 0 || selectedItemStack.getItem() instanceof KeybladeItem) {
            stats.add((Component)Component.literal((String)(Utils.translateToLocal("gui.menu.status.strength", new Object[0]) + ": " + str)).withStyle(ChatFormatting.DARK_RED));
        }
        if (mag != 0 || selectedItemStack.getItem() instanceof KeybladeItem) {
            stats.add((Component)Component.literal((String)(Utils.translateToLocal("gui.menu.status.magic", new Object[0]) + ": " + mag)).withStyle(ChatFormatting.BLUE));
        }
        if (def != 0) {
            stats.add((Component)Component.literal((String)(Utils.translateToLocal("gui.menu.status.defense", new Object[0]) + ": " + def)).withStyle(ChatFormatting.WHITE));
        }
        if (fireRes != 0) {
            stats.add((Component)Component.literal((String)(Utils.translateToLocal("gui.menu.status.fireresshort", new Object[0]) + ": " + fireRes + "%")).withStyle(ChatFormatting.RED));
        }
        if (iceRes != 0) {
            stats.add((Component)Component.literal((String)(Utils.translateToLocal("gui.menu.status.blizzardresshort", new Object[0]) + ": " + iceRes + "%")).withStyle(ChatFormatting.AQUA));
        }
        if (thunderRes != 0) {
            stats.add((Component)Component.literal((String)(Utils.translateToLocal("gui.menu.status.thunderresshort", new Object[0]) + ": " + thunderRes + "%")).withStyle(ChatFormatting.YELLOW));
        }
        if (lightRes != 0) {
            stats.add((Component)Component.literal((String)(Utils.translateToLocal("gui.menu.status.lightresshort", new Object[0]) + ": " + lightRes + "%")).withStyle(ChatFormatting.GRAY));
        }
        if (darkRes != 0) {
            stats.add((Component)Component.literal((String)(Utils.translateToLocal("gui.menu.status.darkresshort", new Object[0]) + ": " + darkRes + "%")).withStyle(ChatFormatting.DARK_GRAY));
        }
        return stats;
    }

    public static ResourceLocation getItemRegistryName(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }

    public static ResourceLocation getBlockRegistryName(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    public static float map(float x, float in_min, float in_max, float out_min, float out_max) {
        return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
    }

    public static int getSlotFor(Inventory inv, ItemStack stack) {
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            if (inv.getItem(i).isEmpty() || !ItemStack.matches((ItemStack)stack, (ItemStack)inv.getItem(i))) continue;
            return i;
        }
        return -1;
    }

    public static boolean isNumber(char c) {
        try {
            Integer.parseInt(String.valueOf(c));
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static int getInt(String num) {
        try {
            int number = Integer.parseInt(num);
            return number;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static double getDouble(String num) {
        try {
            double number = Double.parseDouble(num);
            return number;
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public static int clamp(int value, int min, int max) {
        return Math.min(Math.max(value, min), max);
    }

    public static float clamp(float value, float min, float max) {
        return Math.min(Math.max(value, min), max);
    }

    public static double clamp(double value, double min, double max) {
        return Math.min(Math.max(value, min), max);
    }

    public static int randomWithRange(int min, int max) {
        int range = Math.abs(max - min) + 1;
        return (int)(Math.random() * (double)range) + Math.min(min, max);
    }

    public static double randomWithRange(double min, double max) {
        double range = Math.abs(max - min);
        return Math.random() * range + Math.min(min, max);
    }

    public static float randomWithRange(float min, float max) {
        float range = Math.abs(max - min) + 1.0f;
        return (float)(Math.random() * (double)range) + Math.min(min, max);
    }

    public static String translateToLocalFormatted(String name, Object ... format) {
        MutableComponent translation = Component.translatable((String)name, (Object[])format);
        return translation.getString();
    }

    public static String translateToLocal(String name, Object ... args) {
        MutableComponent translation = Component.translatable((String)name, (Object[])args);
        return translation.getString();
    }

    public static ItemStack getWeaponDamageStack(DamageSource damageSource, Player player) {
        switch (damageSource.getMsgId()) {
            case "player": {
                if ((player.getMainHandItem() == null || !(player.getMainHandItem().getItem() instanceof KeybladeItem)) && !(player.getMainHandItem().getItem() instanceof IOrgWeapon)) break;
                return player.getMainHandItem();
            }
            case "offhand": {
                if ((player.getOffhandItem() == null || !(player.getOffhandItem().getItem() instanceof KeybladeItem)) && !(player.getOffhandItem().getItem() instanceof IOrgWeapon)) break;
                return player.getOffhandItem();
            }
        }
        return null;
    }

    public static int getDriveFormLevel(Map<String, int[]> map, String driveForm) {
        if (map.get(driveForm) == null) {
            KingdomKeys.LOGGER.error("The drive form map doesn't contain " + driveForm);
            return 0;
        }
        if (driveForm.equals("kingdomkeys:form_anti")) {
            return 7;
        }
        return map.get(driveForm)[0];
    }

    public static LinkedHashMap<Item, Integer> getSortedMaterials(Map<Item, Integer> materials) {
        ArrayList<Item> list = new ArrayList<Item>(materials.keySet());
        list.sort(Comparator.comparing(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getKey(arg_0)));
        LinkedHashMap<Item, Integer> map = new LinkedHashMap<Item, Integer>();
        for (Item k : list) {
            map.put(k, materials.get(k));
        }
        return map;
    }

    public static LinkedHashMap<String, int[]> getSortedAbilities(LinkedHashMap<String, int[]> abilities) {
        return abilities.entrySet().stream().sorted((entry, entry2) -> {
            Ability ability = (Ability)ModAbilities.registry.get(ResourceLocation.parse((String)((String)entry.getKey())));
            Ability ability2 = (Ability)ModAbilities.registry.get(ResourceLocation.parse((String)((String)entry2.getKey())));
            if (ability != null && ability2 != null) {
                return ability.compareTo(ability2);
            }
            return ((String)entry.getKey()).compareTo((String)entry2.getKey());
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (value, value2) -> value, LinkedHashMap::new));
    }

    public static LinkedHashMap<String, int[]> getSortedDriveForms(LinkedHashMap<String, int[]> driveFormsMap, List<DriveForm> visibleForms) {
        ArrayList<DriveForm> list = new ArrayList<DriveForm>();
        for (String entry : driveFormsMap.keySet()) {
            DriveForm form = (DriveForm)ModDriveForms.registry.get(ResourceLocation.parse((String)entry));
            if (!visibleForms.contains(form)) continue;
            list.add(form);
        }
        list.sort(Comparator.comparingInt(DriveForm::getOrder));
        LinkedHashMap<String, int[]> map = new LinkedHashMap<String, int[]>();
        for (DriveForm driveForm : list) {
            map.put(driveForm.getRegistryName().toString(), driveFormsMap.get(driveForm.getRegistryName().toString()));
        }
        return map;
    }

    public static List<Limit> getPlayerLimitAttacks(Player player) {
        ArrayList<Limit> limits = new ArrayList<Limit>(ModLimits.registry.stream().toList());
        return limits;
    }

    public static List<Limit> getSortedLimits(List<Limit> list) {
        ArrayList<Limit> newList = new ArrayList<Limit>(list);
        newList.sort(Comparator.comparingInt(Limit::getOrder));
        return newList;
    }

    public static List<String> getSortedShotlocks(List<String> list) {
        ArrayList<String> newList = new ArrayList<String>(list);
        newList.sort(Comparator.comparingInt(a -> ((Shotlock)ModShotlocks.registry.get(ResourceLocation.parse((String)a))).getOrder()));
        return newList;
    }

    public static Player getPlayerByName(Level world, String name) {
        List<Player> players = world.getServer() == null ? world.players() : Utils.getAllPlayers(world.getServer());
        for (Player p : players) {
            if (!p.getDisplayName().getString().equalsIgnoreCase(name)) continue;
            return p;
        }
        return null;
    }

    public static Player getClosestPlayer(Entity e, Level world) {
        Player nearest = null;
        if (e.getServer() == null) {
            return null;
        }
        List<Player> players = world == null ? Utils.getAllPlayers(e.getServer()) : world.players();
        for (Player p : players) {
            if (nearest == null) {
                nearest = p;
            }
            if (!(p.distanceTo(e) < nearest.distanceTo(e))) continue;
            nearest = p;
        }
        return nearest;
    }

    public static Player getClosestPlayer(Entity e) {
        return Utils.getClosestPlayer(e, null);
    }

    public static List<Player> getAllPlayers(MinecraftServer ms) {
        ArrayList<Player> list = new ArrayList<Player>();
        for (ServerLevel world : ms.getAllLevels()) {
            for (Player p : world.players()) {
                list.add(p);
            }
        }
        return list;
    }

    public static List<LivingEntity> getLivingEntitiesInRadius(Entity entity, float radius) {
        List list = entity.level().getEntities(entity, entity.getBoundingBox().inflate((double)radius), Entity::isAlive);
        ArrayList<LivingEntity> elList = new ArrayList<LivingEntity>();
        for (Entity e : list) {
            if (!(e instanceof LivingEntity)) continue;
            elList.add((LivingEntity)e);
        }
        return elList;
    }

    public static List<Entity> removePartyMembersFromList(Player player, List<Entity> list) {
        Party casterParty = WorldData.get(player.getServer()).getPartyFromMember(player.getUUID());
        if (casterParty != null && !casterParty.getFriendlyFire()) {
            for (Party.Member m : casterParty.getMembers()) {
                list.remove(player.level().getPlayerByUUID(m.getUUID()));
            }
        } else {
            list.remove(player);
        }
        return list;
    }

    public static boolean anyPartyMemberOnExcept(Player player, Party p, ServerLevel level) {
        boolean membersOn = false;
        for (Party.Member member : p.getMembers()) {
            if (Utils.getPlayerByName((Level)level, member.getUsername().toLowerCase()) == null || Utils.getPlayerByName((Level)level, member.getUsername().toLowerCase()) == player) continue;
            membersOn = true;
        }
        return membersOn;
    }

    public static List<LivingEntity> getLivingEntitiesInRadiusExcludingParty(Player player, float radius) {
        List list = player.level().getEntities((Entity)player, player.getBoundingBox().inflate((double)radius), Entity::isAlive);
        Party casterParty = WorldData.get(player.getServer()).getPartyFromMember(player.getUUID());
        if (casterParty != null && !casterParty.getFriendlyFire()) {
            for (Party.Member m : casterParty.getMembers()) {
                list.remove(player.level().getPlayerByUUID(m.getUUID()));
            }
        } else {
            list.remove(player);
        }
        ArrayList<LivingEntity> elList = new ArrayList<LivingEntity>();
        for (Entity e : list) {
            if (!(e instanceof LivingEntity)) continue;
            elList.add((LivingEntity)e);
        }
        return elList;
    }

    public static List<LivingEntity> getLivingEntitiesInRadiusExcludingParty(Player player, Entity entity, float radiusX, float radiusY, float radiusZ) {
        List list = player.level().getEntities((Entity)player, entity.getBoundingBox().inflate((double)radiusX, (double)radiusY, (double)radiusZ), Entity::isAlive);
        Party casterParty = WorldData.get(player.getServer()).getPartyFromMember(player.getUUID());
        if (casterParty != null && !casterParty.getFriendlyFire()) {
            for (Party.Member m : casterParty.getMembers()) {
                list.remove(player.level().getPlayerByUUID(m.getUUID()));
            }
        } else {
            list.remove(player);
        }
        list.remove(entity);
        ArrayList<LivingEntity> elList = new ArrayList<LivingEntity>();
        for (Entity e : list) {
            if (!(e instanceof LivingEntity)) continue;
            elList.add((LivingEntity)e);
        }
        return elList;
    }

    public static String getResourceName(String text) {
        return text.replaceAll("[ \\t]+$", "").replaceAll("\\s+", "_").replaceAll("[\\'\\:\\-\\,\\#]", "").replaceAll("\\&", "and").toLowerCase();
    }

    public static void createKeybladeID(ItemStack stack) {
        if (!Utils.hasKeybladeID(stack)) {
            UUID uuid = UUID.randomUUID();
            stack.set(ModComponents.KEYBLADE_ID, (Object)uuid);
            KingdomKeys.LOGGER.debug("Created new keybladeID:{} for {}", (Object)uuid, (Object)stack.getDisplayName().getString());
        }
    }

    public static void copyKeybladeID(ItemStack source, ItemStack destination) {
        if (Utils.hasKeybladeID(source)) {
            destination.set(ModComponents.KEYBLADE_ID, (Object)((UUID)source.get(ModComponents.KEYBLADE_ID)));
        }
    }

    public static boolean hasKeybladeID(ItemStack stack) {
        return stack.has(ModComponents.KEYBLADE_ID) && !stack.is(Items.AIR);
    }

    public static UUID getKeybladeID(ItemStack stack) {
        if (Utils.hasKeybladeID(stack)) {
            return (UUID)stack.getOrDefault(ModComponents.KEYBLADE_ID, (Object)Util.NIL_UUID);
        }
        return null;
    }

    public static void armourTick(ItemStack stack, Entity entity, Level level, int slot) {
        if (entity instanceof Player) {
            PlayerData playerData;
            Player player = (Player)entity;
            if (!level.isClientSide && (playerData = PlayerData.get(player)) != null) {
                UUID armorUUID;
                UUID uUID = armorUUID = playerData.getEquippedKBArmor(0).getItem() != null ? Utils.getArmorID(playerData.getEquippedKBArmor(0)) : null;
                if (Utils.hasArmorID(stack)) {
                    if (Utils.getArmorID(stack).equals(armorUUID)) {
                        if (player.getInventory().getItem(36) != stack && player.getInventory().getItem(37) != stack && player.getInventory().getItem(38) != stack && player.getInventory().getItem(39) != stack) {
                            Utils.desummonArmour(playerData, player, stack, slot, true, true);
                        }
                    } else {
                        Utils.desummonArmour(playerData, player, stack, slot, false, true);
                    }
                }
            }
        }
    }

    public static void desummonArmour(PlayerData playerData, Player player, ItemStack stack, int slot, boolean sameUUID, boolean playSound) {
        if (sameUUID) {
            PauldronInventory pauldronInventory = (PauldronInventory)((Object)playerData.getEquippedKBArmor(0).getCapability(Capabilities.ItemHandler.ITEM));
            Item item = stack.getItem();
            if (item instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)item;
                stack.remove(ModComponents.ARMOR_ID);
                pauldronInventory.setStackInSlot(armorItem.getType().ordinal(), stack);
            }
        }
        player.getInventory().setItem(slot, ItemStack.EMPTY);
        if (playSound) {
            player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.unsummon.get(), SoundSource.MASTER, 1.0f, 1.0f);
        }
    }

    public static boolean hasArmorID(ItemStack stack) {
        if (stack.getItem() instanceof PauldronItem || stack.getItem() instanceof ArmorItem) {
            return stack.has(ModComponents.ARMOR_ID);
        }
        return false;
    }

    public static UUID getArmorID(ItemStack stack) {
        if (Utils.hasArmorID(stack)) {
            return (UUID)stack.get(ModComponents.ARMOR_ID);
        }
        return null;
    }

    public static int findSummoned(Inventory inv, ItemStack chain) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>((Collection<ItemStack>)inv.items);
        list.addAll((Collection<ItemStack>)inv.armor);
        list.addAll((Collection<ItemStack>)inv.offhand);
        return Utils.findSummoned(list, chain);
    }

    public static int findSummoned(List<ItemStack> inv, ItemStack chain) {
        if (!ItemStack.matches((ItemStack)chain, (ItemStack)ItemStack.EMPTY)) {
            for (int i = 0; i < inv.size(); ++i) {
                ItemStack slotStack = inv.get(i);
                if (!Utils.hasKeybladeID(slotStack) || !Utils.hasKeybladeID(chain) || !Utils.getKeybladeID(slotStack).equals(Utils.getKeybladeID(chain))) continue;
                return i;
            }
        }
        return -1;
    }

    public static int findSummoned(Inventory inv) {
        ArrayList list = new ArrayList(inv.items);
        list.addAll(inv.armor);
        list.addAll(inv.offhand);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack slotStack = (ItemStack)list.get(i);
            if (!Utils.hasKeybladeID(slotStack) || !(slotStack.getItem() instanceof KeybladeItem)) continue;
            return i;
        }
        return -1;
    }

    public static void swapStack(Inventory inv, int stack1, int stack2) {
        ItemStack tempStack = inv.getItem(stack2);
        inv.setItem(stack2, inv.getItem(stack1));
        inv.setItem(stack1, tempStack);
    }

    public static ItemCategory getCategoryForStack(ItemStack stack) {
        ItemCategory category = ItemCategory.MISC;
        if (stack.getItem() instanceof IItemCategory) {
            category = ((IItemCategory)stack.getItem()).getCategory();
        } else if (ItemCategoryRegistry.hasCategory(stack.getItem())) {
            category = ItemCategoryRegistry.getCategory(stack.getItem());
        }
        return category;
    }

    public static ItemCategory getCategoryForRecipe(ResourceLocation location) {
        if (RecipeRegistry.getInstance().containsKey(location)) {
            return Utils.getCategoryForStack(new ItemStack((ItemLike)RecipeRegistry.getInstance().getValue(location).getResult()));
        }
        return ItemCategory.MISC;
    }

    public static ItemCategory getCategoryForShop(ResourceLocation stackRL) {
        return Utils.getCategoryForStack(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(stackRL)));
    }

    public static int getAccessoriesStat(PlayerData playerData, String type) {
        int res = 0;
        int c = 1;
        for (Map.Entry<Integer, ItemStack> entry : playerData.getEquippedAccessories().entrySet()) {
            if (c > playerData.getMaxAccessories()) break;
            if (ItemStack.matches((ItemStack)entry.getValue(), (ItemStack)ItemStack.EMPTY)) continue;
            KKAccessoryItem accessory = (KKAccessoryItem)entry.getValue().getItem();
            switch (type) {
                case "ap": {
                    res += accessory.getAp();
                    break;
                }
                case "str": {
                    res += accessory.getStr();
                    break;
                }
                case "mag": {
                    res += accessory.getMag();
                }
            }
        }
        return res;
    }

    public static List<String> getAccessoriesAbilities(PlayerData playerData) {
        ArrayList<String> res = new ArrayList<String>();
        int c = 1;
        for (Map.Entry<Integer, ItemStack> entry : playerData.getEquippedAccessories().entrySet()) {
            if (c > playerData.getMaxAccessories()) break;
            if (!ItemStack.matches((ItemStack)entry.getValue(), (ItemStack)ItemStack.EMPTY)) {
                KKAccessoryItem accessory = (KKAccessoryItem)entry.getValue().getItem();
                res.addAll(accessory.getAbilities());
            }
            ++c;
        }
        return res;
    }

    public static int getArmorsStat(Map<Integer, ItemStack> equipped, String type) {
        int res = 0;
        for (Map.Entry<Integer, ItemStack> entry : equipped.entrySet()) {
            if (ItemStack.matches((ItemStack)entry.getValue(), (ItemStack)ItemStack.EMPTY)) continue;
            KKArmorItem kkArmorItem = (KKArmorItem)entry.getValue().getItem();
            switch (type) {
                case "def": {
                    res += kkArmorItem.getDefense();
                    break;
                }
                case "darkness": {
                    if (!kkArmorItem.CheckKey(KKResistanceType.darkness)) break;
                    res += kkArmorItem.GetResValue(KKResistanceType.darkness, res == 0 ? 100 : 100 - res);
                    break;
                }
                case "light": {
                    if (!kkArmorItem.CheckKey(KKResistanceType.light)) break;
                    res += kkArmorItem.GetResValue(KKResistanceType.light, res == 0 ? 100 : 100 - res);
                    break;
                }
                case "ice": {
                    if (!kkArmorItem.CheckKey(KKResistanceType.ice)) break;
                    res += kkArmorItem.GetResValue(KKResistanceType.ice, res == 0 ? 100 : 100 - res);
                    break;
                }
                case "air": {
                    if (!kkArmorItem.CheckKey(KKResistanceType.air)) break;
                    res += kkArmorItem.GetResValue(KKResistanceType.air, res == 0 ? 100 : 100 - res);
                    break;
                }
                case "lightning": {
                    if (!kkArmorItem.CheckKey(KKResistanceType.lightning)) break;
                    res += kkArmorItem.GetResValue(KKResistanceType.lightning, res == 0 ? 100 : 100 - res);
                    break;
                }
                case "water": {
                    if (!kkArmorItem.CheckKey(KKResistanceType.water)) break;
                    res += kkArmorItem.GetResValue(KKResistanceType.water, res == 0 ? 100 : 100 - res);
                    break;
                }
                case "fire": {
                    if (!kkArmorItem.CheckKey(KKResistanceType.fire)) break;
                    res += kkArmorItem.GetResValue(KKResistanceType.fire, res == 0 ? 100 : 100 - res);
                }
            }
        }
        return res;
    }

    public static int getArmorsStat(PlayerData playerData, String type) {
        return Utils.getArmorsStat(playerData.getEquippedArmors(), type);
    }

    public static int getConsumedAP(PlayerData playerData) {
        int ap = 0;
        LinkedHashMap<String, int[]> map = playerData.getAbilityMap();
        for (Map.Entry<String, int[]> entry : map.entrySet()) {
            Ability a = (Ability)ModAbilities.registry.get(ResourceLocation.parse((String)entry.getKey()));
            ap += a.getAPCost() * Integer.bitCount(entry.getValue()[1]);
        }
        return ap;
    }

    public static double getMPHasteValue(PlayerData playerData) {
        int val = 0;
        val += 2 * playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_mp_haste");
        val += 4 * playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_mp_hastera");
        return val += 6 * playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_mp_hastega");
    }

    public static void RefreshAbilityAttributes(Player player, PlayerData playerData) {
        if (player.level().isClientSide) {
            return;
        }
        HashMultimap map = HashMultimap.create();
        AttributeModifier attributemodifier = new AttributeModifier(ResourceLocation.parse((String)"kingdomkeys:ability_lucky_lucky"), (double)playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_lucky_lucky"), AttributeModifier.Operation.ADD_VALUE);
        map.put((Object)Attributes.LUCK, (Object)attributemodifier);
        player.getAttributes().addTransientAttributeModifiers((Multimap)map);
    }

    public static boolean isWearingOrgRobes(Player player) {
        if (!((Boolean)ModConfigs.SERVER.orgEnabled.get()).booleanValue()) {
            return false;
        }
        boolean wearingOrgCloak = true;
        for (int i = 0; i < player.getInventory().armor.size(); ++i) {
            ItemStack itemStack = (ItemStack)player.getInventory().armor.get(i);
            if (!itemStack.isEmpty() && (BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).getPath().startsWith("organization_") || BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).getPath().startsWith("xemnas_") || BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).getPath().startsWith("anticoat_"))) continue;
            wearingOrgCloak = false;
            break;
        }
        return wearingOrgCloak;
    }

    public static int getBagCosts(int bagLevel) {
        return bagCosts[bagLevel];
    }

    public static String snakeToCamel(String str) {
        str = ((String)str).substring(0, 1).toUpperCase() + ((String)str).substring(1);
        while (((String)str).contains("_")) {
            str = ((String)str).replaceFirst("_[a-z]", String.valueOf(Character.toUpperCase(((String)str).charAt(((String)str).indexOf("_") + 1))));
        }
        str = ((String)str).substring(0, 1).toLowerCase() + ((String)str).substring(1);
        return str;
    }

    public static float getTargetPitch(Entity entity, Entity target) {
        double xDiff = target.getX() - entity.getX();
        double yDiff = target.getY() - entity.getY();
        double zDiff = target.getZ() - entity.getZ();
        double distance = Mth.sqrt((float)((float)(xDiff * xDiff + zDiff * zDiff)));
        return (float)(-(Mth.atan2((double)yDiff, (double)distance) * 57.2957763671875));
    }

    public static float getTargetYaw(Entity entity, Entity target) {
        double d0 = target.getX() - entity.getX();
        double d1 = target.getZ() - entity.getZ();
        return (float)(-(Mth.atan2((double)d1, (double)d0) * 57.2957763671875)) - 90.0f;
    }

    public static Shotlock getPlayerShotlock(Player player) {
        PlayerData playerData = PlayerData.get(player);
        if (!playerData.getEquippedShotlock().isEmpty()) {
            return (Shotlock)ModShotlocks.registry.get(ResourceLocation.parse((String)playerData.getEquippedShotlock()));
        }
        return null;
    }

    public static boolean isPlayerLowHP(Player player) {
        return player.getHealth() < player.getMaxHealth() / 4.0f;
    }

    public static Map<Integer, ItemStack> getEquippedItems(Map<Integer, ItemStack> equippedItems) {
        HashMap<Integer, ItemStack> finalMap = new HashMap<Integer, ItemStack>(equippedItems);
        for (Map.Entry<Integer, ItemStack> entry : equippedItems.entrySet()) {
            ItemStack stack = entry.getValue();
            if (!ItemStack.matches((ItemStack)stack, (ItemStack)ItemStack.EMPTY)) continue;
            finalMap.remove(entry.getKey());
        }
        return finalMap;
    }

    public static boolean isEntityInParty(Party party, Entity e) {
        if (party == null) {
            return false;
        }
        List<Party.Member> list = party.getMembers();
        for (Party.Member m : list) {
            if (!m.getUUID().equals(e.getUUID())) continue;
            return true;
        }
        return false;
    }

    public static List<Entity> removeFriendlyEntities(List<Entity> list) {
        ArrayList<Entity> list2 = new ArrayList<Entity>();
        for (Entity e : list) {
            if (!(e instanceof Monster) && !(e instanceof Player)) continue;
            list2.add(e);
        }
        return list2;
    }

    public static boolean isHostile(Entity e) {
        return e instanceof Monster || e instanceof Player || e instanceof Slime;
    }

    public static List<String> getKeybladeAbilitiesAtLevel(Item item, int level) {
        ArrayList<String> abilities = new ArrayList<String>();
        KeybladeItem keyblade = null;
        if (item instanceof IKeychain) {
            keyblade = ((IKeychain)item).toSummon();
        } else if (item instanceof KeybladeItem) {
            keyblade = (KeybladeItem)item;
        }
        if (keyblade != null) {
            for (int i = 0; i <= level; ++i) {
                String a = keyblade.data.getLevelAbility(i);
                if (a == null) continue;
                abilities.add(a);
            }
        }
        return abilities;
    }

    public static List<String> getOrgWeaponAbilities(Item item) {
        IOrgWeapon org;
        String[] a;
        ArrayList<String> abilities = new ArrayList<String>();
        Object keyblade = null;
        if (item instanceof IOrgWeapon && (a = (org = (IOrgWeapon)item).getOrganizationData().getAbilities()) != null) {
            abilities.addAll(Arrays.asList(a));
        }
        return abilities;
    }

    public static void restartLevel(PlayerData playerData, Player player) {
        playerData.setLevel(1);
        playerData.setExperience(0);
        playerData.setMaxHP(20);
        player.setHealth((float)playerData.getMaxHP());
        player.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)playerData.getMaxHP());
        playerData.setMaxMP(0.0);
        playerData.setMP(playerData.getMaxMP());
        playerData.setStrength(1);
        playerData.setMagic(1);
        playerData.setDefense(1);
        playerData.setMaxAP(0);
        playerData.setMaxAccessories(0);
        playerData.setMaxArmors(0);
        playerData.clearAbilities();
        SoAState.applyStatsForChoices(player, playerData, false);
        playerData.setEquippedShotlock("");
        playerData.getShotlockList().clear();
    }

    public static void restartLevel2(PlayerData playerData, Player player) {
        LinkedHashMap<String, int[]> driveForms = playerData.getDriveFormMap();
        for (Map.Entry<String, int[]> entry : driveForms.entrySet()) {
            int dfLevel = entry.getValue()[0];
            DriveForm form = (DriveForm)ModDriveForms.registry.get(ResourceLocation.parse((String)entry.getKey()));
            if (form.getRegistryName().equals((Object)DriveForm.NONE) || form.getRegistryName().equals((Object)DriveForm.SYNCH_BLADE)) continue;
            for (int i = 1; i <= dfLevel; ++i) {
                String baseAbility = form.getBaseAbilityForLevel(i);
                if (baseAbility == null || baseAbility.equals("")) continue;
                playerData.addAbility(baseAbility, false);
            }
        }
        player.heal((float)playerData.getMaxHP());
        playerData.setMP(playerData.getMaxMP());
    }

    public static String getTierFromInt(int tier) {
        return switch (tier) {
            case 1 -> "D";
            case 2 -> "C";
            case 3 -> "B";
            case 4 -> "A";
            case 5 -> "S";
            case 6 -> "SS";
            case 7 -> "SSS";
            default -> "Unknown: " + tier;
        };
    }

    public static int getFreeSlotsForPlayer(Player player) {
        int free = 0;
        for (ItemStack stack : player.getInventory().items) {
            if (!ItemStack.matches((ItemStack)ItemStack.EMPTY, (ItemStack)stack)) continue;
            ++free;
        }
        return free;
    }

    public static int stacksForItemAmount(ItemStack item, int amount) {
        return (int)Math.round(Math.ceil((double)amount / (double)item.getMaxStackSize()));
    }

    public static int getLootingLevel(Player player) {
        int lvl = 0;
        if (!ItemStack.isSameItem((ItemStack)player.getMainHandItem(), (ItemStack)ItemStack.EMPTY) && player.getMainHandItem().isEnchanted()) {
            lvl += EnchantmentHelper.getTagEnchantmentLevel((Holder)player.registryAccess().holderOrThrow(Enchantments.LOOTING), (ItemStack)player.getMainHandItem());
        }
        if (!ItemStack.isSameItem((ItemStack)player.getOffhandItem(), (ItemStack)ItemStack.EMPTY) && player.getOffhandItem().isEnchanted()) {
            lvl += EnchantmentHelper.getTagEnchantmentLevel((Holder)player.registryAccess().holderOrThrow(Enchantments.LOOTING), (ItemStack)player.getOffhandItem());
        }
        return lvl += PlayerData.get(player).getNumberOfAbilitiesEquipped("kingdomkeys:ability_lucky_lucky");
    }

    public static List<Component> appendEnchantmentNames(String text, ItemEnchantments enchantments) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        arrayList.add((Component)Component.translatable((String)text));
        enchantments.keySet().forEach(enchantmentHolder -> {
            enchantmentHolder.value();
            arrayList.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "- " + Enchantment.getFullname((Holder)enchantmentHolder, (int)enchantments.getLevel(enchantmentHolder)).getString())));
        });
        return arrayList;
    }

    public static int[] getRGBFromDec(int color) {
        int[] colors = new int[]{color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF};
        return colors;
    }

    public static int getDecFromRGB(int r, int g, int b) {
        return 65536 * r + 256 * g + b;
    }

    public static boolean shouldRenderOverlay(Player player) {
        if (ModConfigs.showGuiToggle == ModConfigs.ShowType.HIDE) {
            return false;
        }
        if (!(ModConfigs.showGuiToggle != ModConfigs.ShowType.WEAPON || player.getMainHandItem().getItem() instanceof KeybladeItem || player.getOffhandItem().getItem() instanceof KeybladeItem || player.getMainHandItem().getItem() instanceof IOrgWeapon || player.getOffhandItem().getItem() instanceof IOrgWeapon)) {
            return false;
        }
        return !player.hasEffect(ModMobEffects.KO);
    }

    public static BlockPos stringArrayToBlockPos(String[] temp) {
        return new BlockPos(Utils.getInt(temp[0]), Utils.getInt(temp[1]), Utils.getInt(temp[2]));
    }

    public static void reviveFromKO(LivingEntity entity) {
        entity.removeEffect(ModMobEffects.KO);
    }

    public static int getRandomMobLevel(Player player) {
        if (ModConfigs.mobLevelingUp) {
            PlayerData playerData = PlayerData.get(player);
            if (playerData == null) {
                return 0;
            }
            int avgLevel = playerData.getLevel();
            if (WorldData.get(player.getServer()).getPartyFromMember(player.getUUID()) != null) {
                Party p = WorldData.get(player.getServer()).getPartyFromMember(player.getUUID());
                int total = 0;
                int membersOnline = 0;
                for (Party.Member m : p.getMembers()) {
                    if (Utils.getPlayerByName(player.level(), m.getUsername().toLowerCase()) == null) continue;
                    total += PlayerData.get(Utils.getPlayerByName(player.level(), m.getUsername().toLowerCase())).getLevel();
                    ++membersOnline;
                }
                if (membersOnline == 0) {
                    avgLevel = 1;
                    KingdomKeys.LOGGER.warn("0 members online for this party, this should not be happening, in world " + String.valueOf(player.level().dimension().location()));
                } else {
                    avgLevel = total / membersOnline;
                }
            }
            int level = avgLevel - player.level().random.nextInt(6) + 2;
            level = Utils.clamp(level, 1, 100);
            return level;
        }
        return 0;
    }

    public static ChatFormatting getLevelColor(Player player, int lvl) {
        PlayerData playerData = PlayerData.get(player);
        if (playerData == null) {
            return ChatFormatting.WHITE;
        }
        if (playerData.getLevel() > lvl) {
            return ChatFormatting.GREEN;
        }
        if (playerData.getLevel() == lvl) {
            return ChatFormatting.YELLOW;
        }
        return ChatFormatting.RED;
    }

    public static void playSoundToEveryone(ServerLevel level, SoundEvent sound, float vol, float pitch) {
        for (Player p : Utils.getAllPlayers(level.getServer())) {
            p.level().playSound(null, p.blockPosition(), sound, SoundSource.PLAYERS, vol, pitch);
        }
    }

    public static void summonKeyblade(Player player, boolean forceDesummon, ResourceLocation formToSummonFrom) {
        ItemStack keyblade;
        ItemStack summonedExtraStack;
        ItemStack extraChain;
        boolean useOrg;
        ItemStack chain;
        ItemStack offHeldStack;
        ItemStack heldStack;
        PlayerData playerData;
        block38: {
            block37: {
                playerData = PlayerData.get(player);
                if (playerData.getActiveDriveForm().equals("kingdomkeys:form_anti")) {
                    return;
                }
                heldStack = player.getMainHandItem();
                offHeldStack = player.getOffhandItem();
                chain = playerData.getEquippedKeychain(DriveForm.NONE);
                useOrg = false;
                if (playerData.getAlignment() != OrgMember.NONE) {
                    chain = playerData.getEquippedWeapon().copy();
                    useOrg = true;
                }
                extraChain = null;
                if (formToSummonFrom.equals((Object)DriveForm.NONE)) break block37;
                if (!playerData.getEquippedKeychains().containsKey(formToSummonFrom)) break block38;
                extraChain = playerData.getEquippedKeychain(formToSummonFrom);
                break block38;
            }
            if (playerData.isAbilityEquipped("kingdomkeys:ability_synch_blade")) {
                if (playerData.getAlignment() == OrgMember.NONE || playerData.getEquippedWeapon() != null && playerData.getEquippedWeapon().getItem() instanceof KeybladeItem && playerData.getEquippedKeychain(DriveForm.SYNCH_BLADE) != null) {
                    extraChain = playerData.getEquippedKeychain(DriveForm.SYNCH_BLADE);
                } else {
                    extraChain = chain.copy();
                    for (ItemStack weapon : playerData.getWeaponsUnlocked()) {
                        if (!ItemStack.isSameItem((ItemStack)weapon, (ItemStack)extraChain)) continue;
                        extraChain.applyComponents(weapon.getComponents());
                        break;
                    }
                }
            }
        }
        ArrayList<ItemStack> potentialKeyblades = new ArrayList<ItemStack>((Collection<ItemStack>)player.getInventory().items);
        potentialKeyblades.addAll((Collection<ItemStack>)player.getInventory().armor);
        potentialKeyblades.addAll((Collection<ItemStack>)player.getInventory().offhand);
        int slotSummoned = -1;
        slotSummoned = Utils.findSummoned(potentialKeyblades, chain);
        if (slotSummoned != -1) {
            potentialKeyblades.set(slotSummoned, ItemStack.EMPTY);
        }
        int extraSlotSummoned = -1;
        if (extraChain != null) {
            extraSlotSummoned = Utils.findSummoned(potentialKeyblades, extraChain);
        }
        ItemStack summonedStack = slotSummoned > -1 ? player.getInventory().getItem(slotSummoned) : ItemStack.EMPTY;
        ItemStack itemStack = summonedExtraStack = extraSlotSummoned > -1 ? player.getInventory().getItem(extraSlotSummoned) : ItemStack.EMPTY;
        if (forceDesummon && !(heldStack = summonedStack).isEmpty()) {
            offHeldStack = summonedExtraStack;
        }
        if (forceDesummon || !offHeldStack.isEmpty() && ItemStack.matches((ItemStack)offHeldStack, (ItemStack)summonedExtraStack) && Utils.hasKeybladeID(offHeldStack)) {
            if ((forceDesummon || !heldStack.isEmpty() && ItemStack.matches((ItemStack)heldStack, (ItemStack)summonedStack)) && Utils.hasKeybladeID(offHeldStack) && Utils.getKeybladeID(offHeldStack).equals(Utils.getKeybladeID(extraChain))) {
                extraChain.applyComponents(offHeldStack.getComponents());
                playerData.equipKeychain(formToSummonFrom, extraChain);
                player.getInventory().setItem(extraSlotSummoned, ItemStack.EMPTY);
                player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.unsummon.get(), SoundSource.MASTER, 1.0f, 1.0f);
            }
        } else if (extraSlotSummoned > -1) {
            Utils.swapStack(player.getInventory(), 40, extraSlotSummoned);
            player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.summon.get(), SoundSource.MASTER, 1.0f, 1.0f);
        } else if (extraChain != null && !extraChain.isEmpty()) {
            if (offHeldStack.isEmpty()) {
                keyblade = extraChain.getItem() instanceof IKeychain ? new ItemStack((ItemLike)((IKeychain)extraChain.getItem()).toSummon()) : new ItemStack((ItemLike)extraChain.getItem());
                keyblade.applyComponents(extraChain.getComponents());
                player.getInventory().setItem(40, keyblade);
                player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.summon.get(), SoundSource.MASTER, 1.0f, 1.0f);
                Utils.spawnKeybladeParticles(player, InteractionHand.OFF_HAND);
            } else if (player.getInventory().getFreeSlot() > -1) {
                keyblade = extraChain.getItem() instanceof IKeychain ? new ItemStack((ItemLike)((IKeychain)extraChain.getItem()).toSummon()) : new ItemStack((ItemLike)extraChain.getItem());
                keyblade.applyComponents(extraChain.getComponents());
                Utils.swapStack(player.getInventory(), player.getInventory().getFreeSlot(), 40);
                player.getInventory().setItem(40, keyblade);
                player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.summon.get(), SoundSource.MASTER, 1.0f, 1.0f);
            }
        }
        if (forceDesummon || !heldStack.isEmpty() && Utils.hasKeybladeID(heldStack)) {
            if (Utils.hasKeybladeID(heldStack) && heldStack.has(ModComponents.KEYBLADE_ID) && ((UUID)heldStack.get(ModComponents.KEYBLADE_ID)).equals(chain.get(ModComponents.KEYBLADE_ID))) {
                chain.set(ModComponents.KEYBLADE_ID, (Object)((UUID)heldStack.get(ModComponents.KEYBLADE_ID)));
                chain.applyComponents(heldStack.getComponents());
                if (useOrg) {
                    Set<ItemStack> weapons = playerData.getWeaponsUnlocked();
                    for (ItemStack weapon : weapons) {
                        if (!ItemStack.isSameItem((ItemStack)weapon, (ItemStack)heldStack)) continue;
                        weapon.applyComponents(heldStack.getComponents());
                        break;
                    }
                    playerData.setWeaponsUnlocked(weapons);
                } else {
                    playerData.equipKeychain(DriveForm.NONE, chain);
                }
                if (playerData.isAbilityEquipped("kingdomkeys:ability_synch_blade") && extraChain != null && !extraChain.is(Items.AIR)) {
                    player.getInventory().setItem(40, ItemStack.EMPTY);
                }
                player.getInventory().setItem(slotSummoned, ItemStack.EMPTY);
                player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.unsummon.get(), SoundSource.MASTER, 1.0f, 1.0f);
            }
        } else if (slotSummoned > -1) {
            Utils.swapStack(player.getInventory(), player.getInventory().selected, slotSummoned);
            player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.summon.get(), SoundSource.MASTER, 1.0f, 1.0f);
            Utils.spawnKeybladeParticles(player, InteractionHand.MAIN_HAND);
        } else if (!chain.isEmpty()) {
            if (heldStack.isEmpty()) {
                if (!useOrg) {
                    keyblade = new ItemStack((ItemLike)((IKeychain)chain.getItem()).toSummon());
                    keyblade.applyComponents(chain.getComponents());
                } else {
                    keyblade = chain;
                    Set<ItemStack> weapons = playerData.getWeaponsUnlocked();
                    for (ItemStack weapon : weapons) {
                        if (!ItemStack.isSameItem((ItemStack)weapon, (ItemStack)keyblade)) continue;
                        keyblade.applyComponents(weapon.getComponents());
                        break;
                    }
                }
                Utils.swapStack(player.getInventory(), player.getInventory().selected, player.getInventory().getFreeSlot());
                player.getInventory().setItem(player.getInventory().selected, keyblade);
                player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.summon.get(), SoundSource.MASTER, 1.0f, 1.0f);
                Utils.spawnKeybladeParticles(player, InteractionHand.MAIN_HAND);
            } else if (player.getInventory().getFreeSlot() > -1) {
                if (!useOrg) {
                    keyblade = new ItemStack((ItemLike)((IKeychain)chain.getItem()).toSummon());
                    keyblade.applyComponents(chain.getComponents());
                } else {
                    keyblade = chain;
                    Set<ItemStack> weapons = playerData.getWeaponsUnlocked();
                    for (ItemStack weapon : weapons) {
                        if (!ItemStack.isSameItem((ItemStack)weapon, (ItemStack)keyblade)) continue;
                        keyblade.applyComponents(weapon.getComponents());
                        break;
                    }
                }
                Utils.swapStack(player.getInventory(), player.getInventory().getFreeSlot(), player.getInventory().selected);
                player.getInventory().setItem(player.getInventory().selected, keyblade);
                player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.summon.get(), SoundSource.MASTER, 1.0f, 1.0f);
            }
        }
    }

    private static void spawnKeybladeParticles(Player summoner, InteractionHand hand) {
        Vec3 userPos = new Vec3(summoner.getX(), summoner.getY(), summoner.getZ());
        Vec3 lHandCenter = new Vec3(-0.4, -1.3, -0.38);
        lHandCenter = lHandCenter.yRot((float)Math.toRadians(-summoner.yBodyRot));
        Vec3 rHandCenter = new Vec3(0.4, -1.3, -0.38);
        rHandCenter = rHandCenter.yRot((float)Math.toRadians(-summoner.yBodyRot));
        Vec3 v = null;
        v = hand == InteractionHand.MAIN_HAND ? userPos.add(-rHandCenter.x, rHandCenter.y, -rHandCenter.z) : userPos.add(-lHandCenter.x, lHandCenter.y, -lHandCenter.z);
        ((ServerLevel)summoner.level()).sendParticles((ParticleOptions)ParticleTypes.FIREWORK, v.x, summoner.getY() + 1.0, v.z, 80, 0.0, 0.0, 0.0, 0.2);
    }

    public static boolean isPlayerWithin(Player player, BlockPosBounds bounds) {
        return (int)player.getX() >= bounds.min.getX() && (int)player.getX() <= bounds.max.getX() && (int)player.getY() >= bounds.min.getY() && (int)player.getY() <= bounds.max.getY() && (int)player.getZ() >= bounds.min.getZ() && (int)player.getZ() <= bounds.max.getZ();
    }

    public static boolean isAprilFools() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) == 3 && calendar.get(5) == 1;
    }

    public static void applyMobLevel(LivingEntity mob, int level) {
        if (level != 0) {
            AttributeInstance hp;
            AttributeInstance attack = mob.getAttribute(Attributes.ATTACK_DAMAGE);
            if (attack != null) {
                AttributeModifier attackModifier = attack.getModifier(mobLevelAttackModifier);
                if (attackModifier != null) {
                    attack.removeModifier(attackModifier);
                }
                attack.addPermanentModifier(new AttributeModifier(mobLevelAttackModifier, (double)((float)(level * ModConfigs.mobLevelStats) / 500.0f), AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
            }
            if ((hp = mob.getAttribute(Attributes.MAX_HEALTH)) != null) {
                AttributeModifier hpModifier = hp.getModifier(mobLevelHPModifier);
                if (hpModifier != null) {
                    hp.removeModifier(hpModifier);
                }
                hp.addPermanentModifier(new AttributeModifier(mobLevelHPModifier, (double)((float)(level * ModConfigs.mobLevelStats) / 500.0f), AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
            }
        }
    }

    public static List<DriveForm> getVisibleDriveForms(Player player) {
        return ModDriveForms.registry.stream().filter(driveForm -> driveForm.displayInCommandMenu(player)).toList();
    }

    public static void removeEffects(Holder<MobEffect> effect, LivingEntity entity) {
        if (effect.is(ModMobEffects.GRAVITY) && entity instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)entity;
            PacketHandler.sendTo(new SCRecalculateEyeHeight(), player2);
            if (player2.getForcedPose() != null && !PlayerData.get((Player)player2).getIsGliding()) {
                player2.setForcedPose(null);
            }
        }
        if (effect.is(ModMobEffects.STOP)) {
            GlobalData globalData = GlobalData.get(entity);
            if (entity instanceof Mob) {
                ((Mob)entity).setNoAi(false);
            }
            ArrayList<Float> realDamage = new ArrayList<Float>();
            for (int i = 0; i < globalData.getStopDamage().size(); ++i) {
                if (i % 2 != 0) continue;
                realDamage.add(globalData.getStopDamage().get(i));
            }
            globalData.setStopDamage(realDamage);
            if (entity instanceof ServerPlayer) {
                PacketHandler.sendTo(new SCSyncGlobalData(entity), (ServerPlayer)entity);
            }
        }
        if (entity.level().isClientSide) {
            return;
        }
        if (effect != null) {
            entity.level().getServer().getPlayerList().getPlayers().forEach(player -> player.connection.send((Packet)new ClientboundRemoveMobEffectPacket(entity.getId(), effect)));
        }
    }

    public static enum OrgMember {
        NONE,
        XEMNAS,
        XIGBAR,
        XALDIN,
        VEXEN,
        LEXAEUS,
        ZEXION,
        SAIX,
        AXEL,
        DEMYX,
        LUXORD,
        MARLUXIA,
        LARXENE,
        ROXAS;

        public static final StreamCodec<FriendlyByteBuf, OrgMember> STREAM_CODEC;

        static {
            STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, Enum::ordinal, integer -> OrgMember.values()[integer]);
        }
    }

    public record BlockPosBounds(BlockPos min, BlockPos max) {
        public BlockPosBounds(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
            this(new BlockPos(minX, minY, minZ), new BlockPos(maxX, maxY, maxZ));
        }
    }

    public record castMagic(Player player, Player caster, int level, float fullMPBlastMult, LivingEntity lockOnEntity, Magic magic) {
    }

    public record ShotlockPosition(int id, float x, float y, float z) {
        public static final StreamCodec<FriendlyByteBuf, ShotlockPosition> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ShotlockPosition::id, (StreamCodec)ByteBufCodecs.FLOAT, ShotlockPosition::x, (StreamCodec)ByteBufCodecs.FLOAT, ShotlockPosition::y, (StreamCodec)ByteBufCodecs.FLOAT, ShotlockPosition::z, ShotlockPosition::new);
    }

    public static class Title {
        public String title;
        public String subtitle;
        public int fadeIn = 10;
        public int fadeOut = 20;
        public int displayTime = 70;
        public static StreamCodec<FriendlyByteBuf, Title> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, Title>(){

            public Title decode(FriendlyByteBuf pBuffer) {
                return new Title(pBuffer.readNbt());
            }

            public void encode(FriendlyByteBuf pBuffer, Title pValue) {
                pBuffer.writeNbt((Tag)pValue.write());
            }
        };

        public Title(String title, String subtitle, int fadeIn, int displayTime, int fadeOut) {
            this.title = title;
            this.subtitle = subtitle;
            this.fadeIn = fadeIn;
            this.fadeOut = fadeOut;
            this.displayTime = displayTime;
        }

        public Title(String title, String subtitle) {
            this.title = title;
            this.subtitle = subtitle;
        }

        public Title(CompoundTag compound) {
            this.read(compound);
        }

        public CompoundTag write() {
            CompoundTag compound = new CompoundTag();
            compound.putString("title", this.title);
            compound.putString("subtitle", this.subtitle);
            compound.putInt("fadein", this.fadeIn);
            compound.putInt("fadeout", this.fadeOut);
            compound.putInt("displaytime", this.displayTime);
            return compound;
        }

        public void read(CompoundTag tag) {
            this.title = tag.getString("title");
            this.subtitle = tag.getString("subtitle");
            this.fadeIn = tag.getInt("fadein");
            this.fadeOut = tag.getInt("fadeout");
            this.displayTime = tag.getInt("displaytime");
        }

        public static CompoundTag writeList(List<Title> titles) {
            CompoundTag compound = new CompoundTag();
            for (int i = 0; i < titles.size(); ++i) {
                Title t = titles.get(i);
                compound.put("m" + i, (Tag)t.write());
            }
            compound.putInt("size", titles.size());
            return compound;
        }

        public static List<Title> readList(CompoundTag compound) {
            int size = compound.getInt("size");
            ArrayList<Title> titles = new ArrayList<Title>();
            for (int i = 0; i < size; ++i) {
                titles.add(new Title(compound.getCompound("m" + i)));
            }
            return titles;
        }
    }
}

