/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.world;

import com.mojang.datafixers.util.Pair;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import online.kingdomkeys.kingdomkeys.data.PlayerData;

public class SavePointStorage
extends SavedData {
    private final Map<UUID, SavePoint> savePointRegistry = new HashMap<UUID, SavePoint>();

    public Map<UUID, SavePoint> getAllSavePoints() {
        return this.savePointRegistry;
    }

    public Map<UUID, SavePoint> getGlobalSavePoints() {
        return this.savePointRegistry.entrySet().stream().filter(uuidSavePointEntry -> ((SavePoint)uuidSavePointEntry.getValue()).global()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<UUID, Pair<SavePoint, Instant>> getDiscoveredSavePoints(Player player) {
        HashMap<UUID, Pair<SavePoint, Instant>> filteredRegistry = new HashMap<UUID, Pair<SavePoint, Instant>>();
        Map<UUID, Instant> uuids = PlayerData.get(player).discoveredSavePoints().entrySet().stream().filter(uuidInstantEntry -> this.savePointRegistry.containsKey(uuidInstantEntry.getKey()) && !this.savePointRegistry.get(uuidInstantEntry.getKey()).global).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        PlayerData.get(player).setDiscoveredSavePoints(uuids);
        List<SavePoint> savePointList = this.savePointRegistry.entrySet().stream().filter(uuidSavePointEntry -> uuids.containsKey(uuidSavePointEntry.getKey())).map(Map.Entry::getValue).toList();
        savePointList.forEach(savePoint -> filteredRegistry.put(savePoint.id, Pair.of((Object)savePoint, (Object)((Instant)uuids.get(savePoint.id)))));
        this.getGlobalSavePoints().forEach((uuid, savePoint) -> filteredRegistry.put((UUID)uuid, (Pair<SavePoint, Instant>)Pair.of((Object)savePoint, (Object)savePoint.timeCreated)));
        return filteredRegistry;
    }

    public void addSavePoint(SavePoint savePoint) {
        this.savePointRegistry.put(savePoint.id, savePoint);
        this.setDirty();
    }

    public void removeSavePoint(UUID id) {
        if (this.savePointRegistered(id)) {
            this.savePointRegistry.remove(id);
            this.setDirty();
        }
    }

    public SavePoint getSavePoint(UUID id) {
        return this.savePointRegistry.get(id);
    }

    public boolean savePointRegistered(UUID id) {
        return this.savePointRegistry.containsKey(id);
    }

    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider provider) {
        for (SavePoint savePoint : this.savePointRegistry.values()) {
            nbt.put(savePoint.id.toString(), (Tag)savePoint.serializeNBT());
        }
        return nbt;
    }

    private static SavePointStorage load(CompoundTag nbt, HolderLookup.Provider provider) {
        SavePointStorage data = SavePointStorage.create();
        for (String key : nbt.getAllKeys()) {
            data.addSavePoint(new SavePoint(nbt.getCompound(key)));
        }
        return data;
    }

    private static SavePointStorage create() {
        return new SavePointStorage();
    }

    public static SavePointStorage getStorage(MinecraftServer server) {
        return (SavePointStorage)server.overworld().getDataStorage().computeIfAbsent(new SavedData.Factory(SavePointStorage::create, SavePointStorage::load), "kingdomkeys_savepoints");
    }

    public record SavePoint(UUID id, SavePointType type, String name, BlockPos pos, Pair<UUID, String> owner, ResourceKey<Level> dimension, boolean global, Instant timeCreated) {
        public SavePoint(CompoundTag nbt) {
            this(nbt.getUUID("ID"), SavePointType.values()[nbt.getInt("TYPE")], nbt.getString("NAME"), new BlockPos(nbt.getInt("POSX"), nbt.getInt("POSY"), nbt.getInt("POSZ")), (Pair<UUID, String>)Pair.of((Object)nbt.getUUID("OWNER_UUID"), (Object)nbt.getString("OWNER_NAME")), (ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)nbt.getString("DIM"))), nbt.getBoolean("GLOBAL"), SavePoint.getCreatedTime(nbt));
        }

        private static Instant getCreatedTime(CompoundTag nbt) {
            if (nbt.contains("TIME_EPOCH") && nbt.contains("TIME_NANO")) {
                return Instant.ofEpochSecond(nbt.getLong("TIME_EPOCH"), nbt.getInt("TIME_NANO"));
            }
            return Instant.now();
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.putUUID("ID", this.id);
            nbt.putInt("TYPE", this.type.ordinal());
            nbt.putString("NAME", this.name);
            nbt.putInt("POSX", this.pos.getX());
            nbt.putInt("POSY", this.pos.getY());
            nbt.putInt("POSZ", this.pos.getZ());
            nbt.putUUID("OWNER_UUID", (UUID)this.owner.getFirst());
            nbt.putString("OWNER_NAME", (String)this.owner.getSecond());
            nbt.putString("DIM", this.dimension.location().toString());
            nbt.putBoolean("GLOBAL", this.global);
            nbt.putLong("TIME_EPOCH", this.timeCreated.getEpochSecond());
            nbt.putInt("TIME_NANO", this.timeCreated.getNano());
            return nbt;
        }
    }

    public static enum SavePointType implements StringRepresentable
    {
        NORMAL,
        LINKED,
        WARP;


        public String getSerializedName() {
            return this.name().toLowerCase();
        }
    }
}

