/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.world.dimension;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.serialization.Lifecycle;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.storage.DerivedLevelData;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.LevelEvent;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncDimensionLists;

public class DynamicDimensionManager {
    private static final Set<ResourceKey<Level>> VANILLA_WORLDS = ImmutableSet.of((Object)Level.OVERWORLD, (Object)Level.NETHER, (Object)Level.END);
    private static Set<ResourceKey<Level>> pendingLevelsToUnregister = new HashSet<ResourceKey<Level>>();

    public static ServerLevel getOrCreateLevel(MinecraftServer server, ResourceKey<Level> levelKey, BiFunction<MinecraftServer, ResourceKey<LevelStem>, LevelStem> dimensionFactory) {
        Map map = server.forgeGetWorldMap();
        ServerLevel existingLevel = (ServerLevel)map.get(levelKey);
        if (existingLevel != null) {
            return existingLevel;
        }
        return DynamicDimensionManager.createAndRegisterWorldAndDimension(server, map, levelKey, dimensionFactory);
    }

    public static void markDimensionForUnregistration(MinecraftServer server, ResourceKey<Level> levelToRemove) {
        if (!VANILLA_WORLDS.contains(levelToRemove)) {
            pendingLevelsToUnregister.add(levelToRemove);
        }
    }

    public static Set<ResourceKey<Level>> getWorldsPendingUnregistration() {
        return Collections.unmodifiableSet(pendingLevelsToUnregister);
    }

    @Deprecated
    public static void unregisterScheduledDimensions(MinecraftServer server) {
        Set<ResourceKey<Level>> keysToRemove = pendingLevelsToUnregister;
        pendingLevelsToUnregister = new HashSet<ResourceKey<Level>>();
        WorldOptions worldGenSettings = server.getWorldData().worldGenOptions();
        HashSet<ResourceKey<Level>> removedLevelKeys = new HashSet<ResourceKey<Level>>();
        ServerLevel overworld = server.getLevel(Level.OVERWORLD);
        for (ResourceKey<Level> levelKeyToRemove : keysToRemove) {
            ServerLevel removedLevel = (ServerLevel)server.forgeGetWorldMap().remove(levelKeyToRemove);
            if (removedLevel == null) continue;
            for (ServerPlayer player : Lists.newArrayList((Iterable)removedLevel.players())) {
                ResourceKey respawnKey = player.getRespawnDimension();
                if (keysToRemove.contains(respawnKey)) {
                    respawnKey = Level.OVERWORLD;
                    player.setRespawnPosition(Level.OVERWORLD, null, 0.0f, false, false);
                }
                if (respawnKey == null) {
                    respawnKey = Level.OVERWORLD;
                }
                ServerLevel destinationLevel = server.getLevel(respawnKey);
                BlockPos destinationPos = player.getRespawnPosition();
                if (destinationPos == null) {
                    destinationPos = destinationLevel.getSharedSpawnPos();
                }
                float respawnAngle = player.getRespawnAngle();
                player.teleportTo(destinationLevel, (double)destinationPos.getX(), (double)destinationPos.getY(), (double)destinationPos.getZ(), respawnAngle, 0.0f);
            }
            removedLevel.save(null, false, removedLevel.noSave());
            NeoForge.EVENT_BUS.post((Event)new LevelEvent.Unload((LevelAccessor)removedLevel));
            WorldBorder overworldBorder = overworld.getWorldBorder();
            WorldBorder removedWorldBorder = removedLevel.getWorldBorder();
            List listeners = overworldBorder.listeners;
            BorderChangeListener targetListener = null;
            for (BorderChangeListener listener : listeners) {
                if (!(listener instanceof BorderChangeListener.DelegateBorderChangeListener) || removedWorldBorder != ((BorderChangeListener.DelegateBorderChangeListener)listener).worldBorder) continue;
                targetListener = listener;
                break;
            }
            if (targetListener != null) {
                overworldBorder.removeListener(targetListener);
            }
            removedLevelKeys.add(levelKeyToRemove);
        }
        if (!removedLevelKeys.isEmpty()) {
            LayeredRegistryAccess registries = server.registries();
            RegistryAccess.ImmutableRegistryAccess composite = (RegistryAccess.ImmutableRegistryAccess)registries.compositeAccess();
            HashMap<ResourceKey, MappedRegistry> hashMap = new HashMap<ResourceKey, MappedRegistry>();
            ResourceKey key = ResourceKey.create((ResourceKey)ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"root")), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"dimension"));
            Registry oldRegistry = (Registry)hashMap.get(key);
            Lifecycle oldLifecycle = null;
            MappedRegistry newRegistry = new MappedRegistry(Registries.LEVEL_STEM, oldLifecycle, false);
            for (Map.Entry entry : oldRegistry.entrySet()) {
                ResourceKey oldKey = (ResourceKey)entry.getKey();
                ResourceKey oldLevelKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)oldKey.location());
                LevelStem dimension = (LevelStem)entry.getValue();
                if (oldKey == null || dimension == null || removedLevelKeys.contains(oldLevelKey)) continue;
                Registry.register((Registry)newRegistry, (ResourceKey)oldKey, (Object)dimension);
            }
            hashMap.replace(key, newRegistry);
            server.markWorldsDirty();
            SCSyncDimensionLists.syncClients((Set<ResourceKey<Level>>)ImmutableSet.of(), removedLevelKeys);
        }
    }

    private static ServerLevel createAndRegisterWorldAndDimension(MinecraftServer server, Map<ResourceKey<Level>, ServerLevel> map, ResourceKey<Level> worldKey, BiFunction<MinecraftServer, ResourceKey<LevelStem>, LevelStem> dimensionFactory) {
        HashMap<ResourceKey, MappedRegistry> newmap;
        ServerLevel overworld = server.getLevel(Level.OVERWORLD);
        ResourceKey dimensionKey = ResourceKey.create((ResourceKey)Registries.LEVEL_STEM, (ResourceLocation)worldKey.location());
        LevelStem dimension = dimensionFactory.apply(server, (ResourceKey<LevelStem>)dimensionKey);
        ChunkProgressListener chunkProgressListener = server.progressListenerFactory.create(11);
        Executor executor = server.executor;
        LevelStorageSource.LevelStorageAccess anvilConverter = server.storageSource;
        WorldData worldData = server.getWorldData();
        WorldOptions worldGenSettings = worldData.worldGenOptions();
        DerivedLevelData derivedLevelData = new DerivedLevelData(worldData, worldData.overworldData());
        RandomSequences randomSequences = null;
        LayeredRegistryAccess registries = server.registries();
        RegistryAccess.ImmutableRegistryAccess composite = (RegistryAccess.ImmutableRegistryAccess)registries.compositeAccess();
        HashMap<ResourceKey, MappedRegistry> regmap = new HashMap<ResourceKey, MappedRegistry>(composite.registries);
        ResourceKey key = ResourceKey.create((ResourceKey)ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"root")), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"dimension"));
        MappedRegistry oldRegistry = (MappedRegistry)regmap.get(key);
        Lifecycle oldLifecycle = oldRegistry.registryLifecycle();
        MappedRegistry newRegistry = new MappedRegistry(Registries.LEVEL_STEM, oldLifecycle, false);
        for (Map.Entry entry : oldRegistry.entrySet()) {
            ResourceKey oldKey = (ResourceKey)entry.getKey();
            ResourceKey oldLevelKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)oldKey.location());
            LevelStem dim = (LevelStem)entry.getValue();
            if (dim == null || oldLevelKey == worldKey) continue;
            Registry.register((Registry)newRegistry, (ResourceKey)oldKey, (Object)dim);
        }
        Registry.register((Registry)newRegistry, (ResourceKey)dimensionKey, (Object)dimension);
        regmap.replace(key, newRegistry);
        composite.registries = newmap = regmap;
        ServerLevel newWorld = new ServerLevel(server, executor, anvilConverter, (ServerLevelData)derivedLevelData, worldKey, dimension, chunkProgressListener, false, BiomeManager.obfuscateSeed((long)worldGenSettings.seed()), (List)ImmutableList.of(), false, randomSequences);
        overworld.getWorldBorder().addListener((BorderChangeListener)new BorderChangeListener.DelegateBorderChangeListener(newWorld.getWorldBorder()));
        map.put(worldKey, newWorld);
        server.markWorldsDirty();
        NeoForge.EVENT_BUS.post((Event)new LevelEvent.Load((LevelAccessor)newWorld));
        SCSyncDimensionLists.syncClients((Set<ResourceKey<Level>>)ImmutableSet.of(worldKey), (Set<ResourceKey<Level>>)ImmutableSet.of());
        return newWorld;
    }
}

