/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.block.ModBlocks;
import online.kingdomkeys.kingdomkeys.data.CastleOblivionData;
import online.kingdomkeys.kingdomkeys.entity.block.CardDoorTileEntity;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCastleOblivionInteriorData;
import online.kingdomkeys.kingdomkeys.network.stc.SCUpdateCORooms;
import online.kingdomkeys.kingdomkeys.util.Utils;
import online.kingdomkeys.kingdomkeys.world.dimension.DynamicDimensionManager;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.CastleOblivionInteriorChunkGenerator;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.CastleOblivionEvent;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.floor.Floor;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.registry.ModRoomTypes;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.Room;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomDirection;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomGenerator;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomPos;

public class CastleOblivionHandler {
    public static final ResourceKey<Level> CASTLE_OBLIVION = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"castle_oblivion"));
    public static final Utils.BlockPosBounds entranceBounds = new Utils.BlockPosBounds(-10, 87, 11, -1, 100, 11);
    public static final Utils.BlockPosBounds firstDoorBounds = new Utils.BlockPosBounds(15, 63, 67, 17, 66, 67);
    public static final BlockPos entrancePos = new BlockPos(16, 62, 3);
    public static final BlockPos exitPos = new BlockPos(-5, 90, 6);

    @SubscribeEvent
    public void tick(LevelTickEvent.Pre event) {
        CastleOblivionData.InteriorData interiorData;
        if (!event.getLevel().isClientSide() && event.getLevel().dimension().toString().contains("kingdomkeys:castle_oblivion_interior_") && (interiorData = CastleOblivionData.InteriorData.get((ServerLevel)event.getLevel())) != null) {
            interiorData.getFloors().forEach(floor -> {
                if (floor.shouldTick()) {
                    floor.getPlayers().values().forEach(room -> room.getRoomData(interiorData).getGenerated().tick());
                }
            });
        }
    }

    @SubscribeEvent
    public void breakBlock(BlockEvent.BreakEvent event) {
        if (event.getPlayer().level().dimension().location().toString().contains("castle_oblivion_interior_") && event.getState().getBlock() == ModBlocks.cardDoor.get()) {
            event.setCanceled(true);
        }
    }

    public static void enterCastleOblivion(Player player) {
        if (player.level().getServer() != null) {
            ResourceLocation dimName = ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)("castle_oblivion_interior_" + player.getStringUUID()));
            CastleOblivionData.ExteriorData.get(player.getServer()).addInterior(player.getUUID(), dimName);
            RegistryAccess registryAccess = player.level().registryAccess();
            ResourceKey dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimName);
            Holder.Reference type = registryAccess.registryOrThrow(Registries.DIMENSION_TYPE).getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"castle_oblivion")));
            Holder.Reference biome = registryAccess.registryOrThrow(Registries.BIOME).getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"castle_oblivion_interior")));
            ServerLevel level = DynamicDimensionManager.getOrCreateLevel(player.level().getServer(), (ResourceKey<Level>)dimension, (arg_0, arg_1) -> CastleOblivionHandler.lambda$enterCastleOblivion$2((Holder)biome, (Holder)type, arg_0, arg_1));
            player.changeDimension(new DimensionTransition(level, new Vec3((double)entrancePos.getX(), (double)entrancePos.getY(), (double)entrancePos.getZ()), Vec3.ZERO, player.getYRot(), player.getXRot(), entity -> {}));
        }
    }

    public static void exitCastleOblivion(Floor currentFloor, Room currentRoom, Player player) {
        if (player.level().getServer() != null) {
            player.changeDimension(new DimensionTransition(player.level().getServer().getLevel(CASTLE_OBLIVION), new Vec3((double)exitPos.getX(), (double)exitPos.getY(), (double)exitPos.getZ()), Vec3.ZERO, player.getYRot(), player.getXRot(), entity -> {}));
            NeoForge.EVENT_BUS.post((Event)new CastleOblivionEvent.PlayerChangeRoomEvent(currentRoom, null, player));
            NeoForge.EVENT_BUS.post((Event)new CastleOblivionEvent.PlayerChangeFloorEvent(currentFloor, null, player));
        }
    }

    public static Room createFirstRoom(Player player, CardDoorTileEntity te) {
        CastleOblivionData.InteriorData cap = CastleOblivionData.InteriorData.get((ServerLevel)player.level());
        if (cap != null) {
            Floor floor = cap.getFloorByID(te.getParentRoom().getParentID());
            if (te.getParentRoom().equals(floor.getEntranceHall())) {
                if (floor.getGeneratedRooms().size() == 1) {
                    te.setDestinationRoom(floor.getRoom(new RoomPos(0, 1)));
                    for (Player playerFromList : player.level().players()) {
                        PacketHandler.sendTo(new SCUpdateCORooms(floor.getRooms()), (ServerPlayer)playerFromList);
                    }
                    return RoomGenerator.INSTANCE.generateRoom((ServerLevel)player.level(), floor.getRoom(new RoomPos(0, 1)), ModRoomTypes.SLEEPING_DARKNESS.get(), te.getParentRoom().getGenerated(), RoomDirection.NORTH);
                }
                return floor.getRoom(new RoomPos(0, 1)).getGenerated();
            }
        }
        return null;
    }

    public static void enterFirstRoom(Player player) {
        CastleOblivionData.InteriorData cap = CastleOblivionData.InteriorData.get((ServerLevel)player.level());
        if (cap != null) {
            Room currentRoom = cap.getRoomAtPos(player.blockPosition());
            Floor floor = cap.getFloorByID(currentRoom.parentFloor);
            if (!currentRoom.getType().isEntranceHall()) {
                KingdomKeys.LOGGER.info("something is wrong player should be in the entrance hall room");
            } else if (floor.getGeneratedRooms().size() > 1) {
                Room firstRoom = floor.getRoom(new RoomPos(0, 1)).getGenerated();
                BlockPos newPos = firstRoom.doors.get((Object)RoomDirection.NORTH).pos();
                CardDoorTileEntity te = (CardDoorTileEntity)player.level().getBlockEntity(newPos);
                if (te != null && !((CastleOblivionEvent.PlayerChangeRoomEvent)NeoForge.EVENT_BUS.post((Event)new CastleOblivionEvent.PlayerChangeRoomEvent(currentRoom, firstRoom, player))).isCanceled()) {
                    newPos = newPos.offset(te.getDirection().toMCDirection().getNormal().multiply(2));
                    te.openDoor(true);
                    player.teleportTo((double)newPos.getX(), (double)newPos.getY(), (double)newPos.getZ());
                    PacketHandler.sendTo(new SCSyncCastleOblivionInteriorData(cap, player.level()), (ServerPlayer)player);
                }
            }
        }
    }

    public static boolean isExterior(ResourceKey<Level> level) {
        return level.equals(CASTLE_OBLIVION);
    }

    public static boolean isInterior(ResourceKey<Level> level) {
        return level.location().toString().contains("castle_oblivion_interior_");
    }

    public static boolean inExterior(Player player) {
        return CastleOblivionHandler.isExterior((ResourceKey<Level>)player.level().dimension());
    }

    public static boolean inInterior(Player player) {
        return CastleOblivionHandler.isInterior((ResourceKey<Level>)player.level().dimension());
    }

    @SubscribeEvent
    public void playerTick(PlayerTickEvent.Pre event) {
        if (!event.getEntity().level().isClientSide && CastleOblivionHandler.inExterior(event.getEntity()) && Utils.isPlayerWithin(event.getEntity(), entranceBounds)) {
            CastleOblivionHandler.enterCastleOblivion(event.getEntity());
        }
    }

    @SubscribeEvent
    public void changeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (CastleOblivionHandler.isExterior((ResourceKey<Level>)event.getFrom())) {
            if (CastleOblivionHandler.isInterior((ResourceKey<Level>)event.getTo())) {
                SCSyncCastleOblivionInteriorData.syncClients((ServerLevel)event.getEntity().level());
                event.getEntity().sendSystemMessage((Component)Component.translatable((String)"I REPEAT, CASTLE OBLIVION IS WORK IN PROGRESS DON'T REPORT ANY ISSUES WITH IT YET PLEASE"));
                event.getEntity().sendSystemMessage((Component)Component.translatable((String)"IF YOUR GAME CRASHES HERE IT'S EXPECTED, THE OUTSIDE PART IS PROBABLY SAFE FROM CRASHES BUT NOT HERE DEFINITELY NOT HERE"));
                event.getEntity().sendSystemMessage((Component)Component.translatable((String)"THANK YOU AGAIN - Estelle"));
                ServerLevel level = event.getEntity().level().getServer().getLevel(event.getTo());
                Floor startFloor = Floor.getOrCreateFirstFloor(level);
                NeoForge.EVENT_BUS.post((Event)new CastleOblivionEvent.PlayerChangeFloorEvent(null, startFloor, event.getEntity()));
                PacketHandler.sendTo(new SCUpdateCORooms(CastleOblivionHandler.getCurrentFloor(event.getEntity()).getRooms()), (ServerPlayer)event.getEntity());
                startFloor.floorEntered(event.getEntity());
            }
        } else {
            PacketHandler.sendTo(new SCUpdateCORooms(List.of()), (ServerPlayer)event.getEntity());
        }
    }

    @SubscribeEvent
    public void joinWorld(PlayerEvent.PlayerLoggedInEvent event) {
        if (CastleOblivionHandler.inInterior(event.getEntity())) {
            PacketHandler.sendTo(new SCSyncCastleOblivionInteriorData(CastleOblivionData.InteriorData.get((ServerLevel)event.getEntity().level()), event.getEntity().level()), (ServerPlayer)event.getEntity());
        }
    }

    public static Floor getCurrentFloor(Player player) {
        return CastleOblivionData.InteriorData.get((ServerLevel)player.level()).getFloorAtPos(player.blockPosition());
    }

    @SubscribeEvent
    public void changedRoom(CastleOblivionEvent.PlayerChangeRoomEvent event) {
        if (event.getNewRoom() != null) {
            KingdomKeys.LOGGER.debug("Entered Room: {}", (Object)event.getNewRoom().getPosition());
        }
    }

    @SubscribeEvent
    public void generatedRoom(CastleOblivionEvent.RoomGeneratedEvent event) {
        if (event.getGeneratedRoomData() != null) {
            KingdomKeys.LOGGER.debug("Generated a new room: {}", (Object)event.getGeneratedRoomData().getGenerated());
        }
    }

    private static /* synthetic */ LevelStem lambda$enterCastleOblivion$2(Holder biome, Holder type, MinecraftServer minecraftServer, ResourceKey levelStemResourceKey) {
        CastleOblivionInteriorChunkGenerator generator = new CastleOblivionInteriorChunkGenerator((BiomeSource)new FixedBiomeSource(biome));
        return new LevelStem(type, (ChunkGenerator)generator);
    }
}

