/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.ICancellableEvent;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.floor.Floor;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.Room;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomData;

public class CastleOblivionEvent
extends Event {
    ServerLevel interiorLevel;

    public CastleOblivionEvent(ServerLevel interiorLevel) {
        this.interiorLevel = interiorLevel;
    }

    public ServerLevel getInteriorLevel() {
        return this.interiorLevel;
    }

    public static class PlayerChangeFloorEvent
    extends CastleOblivionEvent
    implements ICancellableEvent {
        Floor currentFloor;
        Floor newFloor;
        Player player;

        public Floor getCurrentFloor() {
            return this.currentFloor;
        }

        public Floor getNewFloor() {
            return this.newFloor;
        }

        public Player getPlayer() {
            return this.player;
        }

        public PlayerChangeFloorEvent(Floor currentFloor, Floor newFloor, Player player) {
            super((ServerLevel)player.level());
            this.currentFloor = currentFloor;
            this.newFloor = newFloor;
            this.player = player;
        }
    }

    public static class PlayerChangeRoomEvent
    extends CastleOblivionEvent
    implements ICancellableEvent {
        Room currentRoom;
        Room newRoom;
        Player player;

        public PlayerChangeRoomEvent(Room currentRoom, Room newRoom, Player player) {
            super((ServerLevel)player.level());
            this.currentRoom = currentRoom;
            this.newRoom = newRoom;
            this.player = player;
        }

        public Room getCurrentRoom() {
            return this.currentRoom;
        }

        public Room getNewRoom() {
            return this.newRoom;
        }

        public Player getPlayer() {
            return this.player;
        }
    }

    public static class RoomGeneratedEvent
    extends CastleOblivionEvent {
        RoomData generatedRoomData;
        Room currentRoom;

        public RoomGeneratedEvent(ServerLevel level, RoomData generatedRoomData, Room currentRoom) {
            super(level);
            this.generatedRoomData = generatedRoomData;
            this.currentRoom = currentRoom;
        }

        public RoomData getGeneratedRoomData() {
            return this.generatedRoomData;
        }

        public Room getCurrentRoom() {
            return this.currentRoom;
        }
    }
}

